/*
 * Decompiled with CFR 0.152.
 */
package accessories.plugins;

import freemind.extensions.PermanentNodeHookAdapter;
import freemind.main.Tools;
import freemind.modes.MindMapNode;
import java.awt.Color;
import java.util.ListIterator;

public class AutomaticLayout
extends PermanentNodeHookAdapter {
    private Color[] colors = new Color[]{new Color(0), new Color(13311), new Color(46137), new Color(0x990000), new Color(0x111111)};
    private String[] fontSize = new String[]{"20", "18", "16", "14", "12"};

    private void setStyle(MindMapNode node) {
        Color mycolor;
        this.logger.finest("updating node id=" + node.getObjectId(this.getController()) + " and text:" + node);
        int depth = this.depth(node);
        this.logger.finest("COLOR, depth=" + depth);
        int myIndex = this.colors.length - 1;
        if (depth < this.colors.length) {
            myIndex = depth;
        }
        if (!Tools.safeEquals(mycolor = this.colors[myIndex], node.getColor())) {
            this.getController().setNodeColor(node, mycolor);
        }
        String myFontSize = this.fontSize[myIndex];
        if (node.getFontSize() != null && !node.getFontSize().equals(myFontSize) || node.getFontSize() == null) {
            this.getController().setFontSize(node, myFontSize);
        }
    }

    private int depth(MindMapNode node) {
        if (node.isRoot()) {
            return 0;
        }
        return this.depth((MindMapNode)node.getParent()) + 1;
    }

    public void onAddChildren(MindMapNode newChildNode) {
        this.logger.finest("onAddChildren " + newChildNode);
        super.onAddChild(newChildNode);
        this.setStyleRecursive(newChildNode);
    }

    public void onUpdateChildrenHook(MindMapNode updatedNode) {
        super.onUpdateChildrenHook(updatedNode);
        this.setStyleRecursive(updatedNode);
    }

    public void onUpdateNodeHook() {
        super.onUpdateNodeHook();
        this.setStyle(this.getNode());
    }

    public void invoke(MindMapNode node) {
        super.invoke(node);
        this.setStyleRecursive(node);
    }

    private void setStyleRecursive(MindMapNode node) {
        this.logger.finest("setStyle " + node);
        this.setStyle(node);
        ListIterator i = node.childrenUnfolded();
        while (i.hasNext()) {
            MindMapNode child = (MindMapNode)i.next();
            this.invoke(child);
        }
    }
}

