/*
 * Decompiled with CFR 0.152.
 */
package accessories.plugins;

import accessories.plugins.util.html.ClickableImageCreator;
import accessories.plugins.util.xslt.ExportDialog;
import freemind.extensions.ExportHook;
import freemind.main.Tools;
import freemind.modes.MapAdapter;
import freemind.modes.MindIcon;
import freemind.modes.MindMapNode;
import freemind.modes.ModeController;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URL;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.JOptionPane;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class ExportWithXSLT
extends ExportHook {
    protected File chooseFile() {
        return this.chooseFile(this.getResourceString("file_type"), this.getResourceString("file_description"));
    }

    public void startupMapHook() {
        super.startupMapHook();
        ModeController mc = this.getController();
        MapAdapter model = this.getController().getMap();
        if (Tools.safeEquals(this.getResourceString("file_type"), "user")) {
            if (model == null) {
                return;
            }
            if (model.getFile() == null || model.isReadOnly()) {
                if (mc.save()) {
                    this.export(model.getFile());
                    return;
                }
                return;
            }
            this.export(model.getFile());
        } else {
            this.transform();
        }
    }

    private void transform() {
        try {
            File saveFile = this.chooseFile();
            MindMapNode root = (MindMapNode)this.getController().getMap().getRoot();
            ClickableImageCreator creator = null;
            boolean create_image = Tools.safeEquals(this.getResourceString("create_html_linked_image"), "true");
            if (create_image) {
                creator = new ClickableImageCreator(root, this.getController(), this.getResourceString("link_replacement_regexp"));
            }
            StringWriter writer = new StringWriter();
            this.getController().getMap().getXml(writer);
            StringReader reader = new StringReader(writer.getBuffer().toString());
            String xsltFileName = this.getResourceString("xslt_file");
            URL xsltUrl = this.getResource(xsltFileName);
            if (xsltUrl == null) {
                this.logger.severe("Can't find " + xsltFileName + " as resource.");
                throw new IllegalArgumentException("Can't find " + xsltFileName + " as resource.");
            }
            InputStream xsltFile = xsltUrl.openStream();
            this.transForm(new StreamSource(reader), xsltFile, saveFile, creator);
            if (Tools.safeEquals(this.getResourceString("create_dir"), "true")) {
                String directoryName = saveFile.getAbsolutePath() + "_files";
                boolean success = true;
                File dir = new File(directoryName);
                if (!dir.exists()) {
                    success = dir.mkdir();
                }
                if (success) {
                    String files = this.getResourceString("files_to_copy");
                    String filePrefix = this.getResourceString("file_prefix");
                    StringTokenizer tokenizer = new StringTokenizer(files, ",");
                    while (tokenizer.hasMoreTokens()) {
                        String next = tokenizer.nextToken();
                        this.copyFromResource(filePrefix, next, directoryName);
                    }
                    if (Tools.safeEquals(this.getResourceString("copy_icons"), "true")) {
                        String directoryName2 = directoryName + File.separatorChar + "icons";
                        File dir2 = new File(directoryName2);
                        if (!dir2.exists()) {
                            success = dir2.mkdir();
                        }
                        if (success) {
                            Vector iconNames = MindIcon.getAllIconNames();
                            for (int i = 0; i < iconNames.size(); ++i) {
                                String iconName = (String)iconNames.get(i);
                                MindIcon myIcon = MindIcon.factory(iconName);
                                this.copyFromResource(MindIcon.getIconsPath(), myIcon.getIconBaseFileName(), directoryName2);
                            }
                        }
                    }
                }
                if (success && create_image) {
                    BufferedImage image = this.createBufferedImage();
                    try {
                        FileOutputStream out = new FileOutputStream(directoryName + File.separator + "image.png");
                        ImageIO.write((RenderedImage)image, "png", out);
                        out.close();
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
                if (!success) {
                    JOptionPane.showMessageDialog(null, this.getResourceString("error_creating_directory"), "Freemind", 0);
                }
            }
            if (Tools.safeEquals(this.getResourceString("load_file"), "true")) {
                this.getController().getFrame().openDocument(saveFile.toURL());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void copyFromResource(String prefix, String fileName, String destinationDirectory) {
        try {
            int len;
            this.logger.finest("searching for " + prefix + fileName);
            URL resource = this.getResource(prefix + fileName);
            if (resource == null) {
                this.logger.severe("Cannot find resource: " + prefix + fileName);
                return;
            }
            InputStream in = resource.openStream();
            FileOutputStream out = new FileOutputStream(destinationDirectory + "/" + fileName);
            byte[] buf = new byte[1024];
            while ((len = in.read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            in.close();
            ((OutputStream)out).close();
        }
        catch (Exception e) {
            this.logger.severe("File not found or could not be copied. Was earching for " + prefix + fileName + " and should go to " + destinationDirectory);
            e.printStackTrace();
        }
    }

    private void export(File file) {
        ExportDialog exp = new ExportDialog(file);
        exp.setVisible(true);
    }

    public void transForm(Source xmlSource, InputStream xsltStream, File resultFile, ClickableImageCreator creator) {
        String areaCode = "";
        if (creator != null) {
            areaCode = creator.generateHtml();
        }
        StreamSource xsltSource = new StreamSource(xsltStream);
        StreamResult result = new StreamResult(resultFile);
        try {
            TransformerFactory transFact = TransformerFactory.newInstance();
            Transformer trans = transFact.newTransformer(xsltSource);
            trans.setParameter("destination_dir", resultFile.getName() + "_files/");
            trans.setParameter("area_code", areaCode);
            trans.setParameter("folding_type", this.getController().getFrame().getProperty("html_export_folding"));
            trans.transform(xmlSource, result);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

