/*
 * Decompiled with CFR 0.152.
 */
package accessories.plugins;

import freemind.controller.actions.ActionFilter;
import freemind.controller.actions.ActionHandler;
import freemind.controller.actions.ActionPair;
import freemind.controller.actions.generated.instance.CompoundAction;
import freemind.controller.actions.generated.instance.CompoundActionType;
import freemind.controller.actions.generated.instance.FormatNodeAction;
import freemind.controller.actions.generated.instance.NewNodeActionType;
import freemind.controller.actions.generated.instance.NodeAction;
import freemind.controller.actions.generated.instance.XmlAction;
import freemind.extensions.HookRegistration;
import freemind.modes.ControllerAdapter;
import freemind.modes.MindMap;
import freemind.modes.ModeController;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Logger;
import javax.xml.bind.JAXBException;

public class FormatNewNodes
implements ActionHandler,
ActionFilter,
HookRegistration {
    private ModeController controller;
    private MindMap mMap;
    private Logger logger;
    private HashMap formatActions;

    public FormatNewNodes(ModeController controller, MindMap map) {
        this.controller = controller;
        this.mMap = map;
        this.logger = controller.getFrame().getLogger(this.getClass().getName());
        this.formatActions = new HashMap();
    }

    public void register() {
        this.controller.getActionFactory().registerHandler(this);
        this.controller.getActionFactory().registerFilter(this);
    }

    public void deRegister() {
        this.controller.getActionFactory().deregisterHandler(this);
        this.controller.getActionFactory().deregisterFilter(this);
    }

    public void executeAction(ActionPair pair) {
        this.detectFormatChanges(pair.getDoAction());
    }

    private void detectFormatChanges(XmlAction doAction) {
        if (doAction instanceof CompoundActionType) {
            CompoundActionType compAction = (CompoundActionType)doAction;
            Iterator i = compAction.getCompoundActionOrSelectNodeActionOrCutNodeAction().iterator();
            while (i.hasNext()) {
                XmlAction childAction = (XmlAction)i.next();
                this.detectFormatChanges(childAction);
            }
        } else if (doAction instanceof FormatNodeAction) {
            this.formatActions.put(doAction.getClass().getName(), doAction);
        }
    }

    public void startTransaction(String name) {
    }

    public void endTransaction(String name) {
    }

    public ActionPair filterAction(ActionPair pair) {
        try {
            if (pair.getDoAction() instanceof NewNodeActionType) {
                NewNodeActionType newNodeAction = (NewNodeActionType)pair.getDoAction();
                CompoundAction compound = ((ControllerAdapter)this.controller).getActionXmlFactory().createCompoundAction();
                compound.getCompoundActionOrSelectNodeActionOrCutNodeAction().add(newNodeAction);
                Iterator i = this.formatActions.values().iterator();
                while (i.hasNext()) {
                    NodeAction formatAction = (NodeAction)i.next();
                    FormatNodeAction copiedFormatAction = (FormatNodeAction)this.controller.unMarshall(this.controller.marshall(formatAction));
                    copiedFormatAction.setNode(newNodeAction.getNewId());
                    compound.getCompoundActionOrSelectNodeActionOrCutNodeAction().add(copiedFormatAction);
                }
                ActionPair newPair = new ActionPair(compound, pair.getUndoAction());
                return newPair;
            }
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
        return pair;
    }
}

