/*
 * Decompiled with CFR 0.152.
 */
package freemind.controller;

import freemind.common.JaxbTools;
import freemind.controller.ColorSwatch;
import freemind.controller.LastOpenedList;
import freemind.controller.MainToolBar;
import freemind.controller.MapModuleManager;
import freemind.controller.MapMouseMotionListener;
import freemind.controller.MapMouseWheelListener;
import freemind.controller.NodeDragListener;
import freemind.controller.NodeDropListener;
import freemind.controller.NodeKeyListener;
import freemind.controller.NodeMotionListener;
import freemind.controller.NodeMouseMotionListener;
import freemind.controller.actions.generated.instance.ObjectFactory;
import freemind.controller.actions.generated.instance.WindowConfigurationStorage;
import freemind.controller.actions.generated.instance.XmlAction;
import freemind.main.FreeMindMain;
import freemind.main.Tools;
import freemind.modes.MindMap;
import freemind.modes.Mode;
import freemind.modes.ModeController;
import freemind.modes.ModesCreator;
import freemind.preferences.FreemindPropertyListener;
import freemind.preferences.layout.OptionPanel;
import freemind.view.MapModule;
import freemind.view.mindmapview.MapView;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.PageFormat;
import java.awt.print.PrinterJob;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;

public class Controller {
    private static Logger logger;
    private ObjectFactory actionXmlFactory;
    private static JColorChooser colorChooser;
    private LastOpenedList lastOpened;
    private MapModuleManager mapModuleManager;
    private HistoryManager history = new HistoryManager();
    private Mode mode;
    private FreeMindMain frame;
    private JToolBar toolbar;
    private NodeMouseMotionListener nodeMouseMotionListener;
    private NodeMotionListener nodeMotionListener;
    private NodeKeyListener nodeKeyListener;
    private NodeDragListener nodeDragListener;
    private NodeDropListener nodeDropListener;
    private MapMouseMotionListener mapMouseMotionListener;
    private MapMouseWheelListener mapMouseWheelListener;
    private ModesCreator modescreator = new ModesCreator(this);
    private PageFormat pageFormat = null;
    private PrinterJob printerJob = null;
    private Icon bswatch = new BackgroundSwatch();
    private boolean antialiasEdges = false;
    private boolean antialiasAll = false;
    private Map fontMap = new HashMap();
    boolean isPrintingAllowed = true;
    boolean menubarVisible = true;
    boolean toolbarVisible = true;
    boolean leftToolbarVisible = true;
    public CloseAction close;
    public Action print;
    public Action printDirect;
    public Action page;
    public Action quit;
    public Action background;
    public OptionAntialiasAction optionAntialiasAction;
    public Action optionHTMLExportFoldingAction;
    public Action optionSelectionMechanismAction;
    public Action about;
    public Action faq;
    public Action documentation;
    public Action license;
    public Action historyPreviousMap;
    public Action historyNextMap;
    public Action navigationPreviousMap;
    public Action navigationNextMap;
    public Action moveToRoot;
    public Action toggleMenubar;
    public Action toggleToolbar;
    public Action toggleLeftToolbar;
    public Action zoomIn;
    public Action zoomOut;
    public PropertyAction propertyAction;
    private static final String[] zooms;
    public static final String JAVA_VERSION;
    private static Vector propertyChangeListeners;

    public Controller(FreeMindMain frame) {
        this.checkJavaVersion();
        this.frame = frame;
        if (logger == null) {
            logger = frame.getLogger(this.getClass().getName());
        }
        this.actionXmlFactory = JaxbTools.getInstance().getObjectFactory();
        this.lastOpened = new LastOpenedList(this, this.getProperty("lastOpened"));
        this.mapModuleManager = new MapModuleManager(this, this.history, this.lastOpened);
        this.nodeMouseMotionListener = new NodeMouseMotionListener(this);
        this.nodeMotionListener = new NodeMotionListener(this);
        this.nodeKeyListener = new NodeKeyListener(this);
        this.nodeDragListener = new NodeDragListener(this);
        this.nodeDropListener = new NodeDropListener(this);
        this.mapMouseMotionListener = new MapMouseMotionListener(this);
        this.mapMouseWheelListener = new MapMouseWheelListener(this);
        this.close = new CloseAction(this);
        this.print = new PrintAction(this, true);
        this.printDirect = new PrintAction(this, false);
        this.page = new PageAction(this);
        this.quit = new QuitAction(this);
        this.background = new BackgroundAction(this, this.bswatch);
        this.about = new AboutAction(this);
        this.faq = new OpenFAQAction(this);
        this.documentation = new DocumentationAction(this);
        this.license = new LicenseAction(this);
        this.historyPreviousMap = new HistoryPreviousMapAction(this);
        this.historyNextMap = new HistoryNextMapAction(this);
        this.navigationPreviousMap = new NavigationPreviousMapAction(this);
        this.navigationNextMap = new NavigationNextMapAction(this);
        this.toggleMenubar = new ToggleMenubarAction(this);
        this.toggleToolbar = new ToggleToolbarAction(this);
        this.toggleLeftToolbar = new ToggleLeftToolbarAction(this);
        this.optionAntialiasAction = new OptionAntialiasAction(this);
        this.optionHTMLExportFoldingAction = new OptionHTMLExportFoldingAction(this);
        this.optionSelectionMechanismAction = new OptionSelectionMechanismAction(this);
        this.zoomIn = new ZoomInAction(this);
        this.zoomOut = new ZoomOutAction(this);
        this.propertyAction = new PropertyAction(this);
        this.moveToRoot = new MoveToRootAction(this);
        this.toolbar = new MainToolBar(this);
        this.getFrame().getContentPane().add((Component)this.toolbar, "North");
        this.setAllActions(false);
        if (!Tools.isAvailableFontFamily(this.getProperty("standardfont"))) {
            System.out.println("Warning: the font you have set as standard - " + this.getProperty("standardfont") + " - is not available.");
            frame.setProperty("standardfont", "SansSerif");
        }
    }

    public void checkJavaVersion() {
        if (JAVA_VERSION.compareTo("1.4.0") < 0) {
            String message = "Warning: FreeMind requires version Java 1.4.0 or higher (your version: " + System.getProperty("java.version") + ", installed in " + System.getProperty("java.home") + ").";
            System.err.println(message);
            JOptionPane.showMessageDialog(null, message, "FreeMind", 2);
        }
    }

    public String getProperty(String property) {
        return this.frame.getProperty(property);
    }

    public int getIntProperty(String property, int defaultValue) {
        return this.frame.getIntProperty(property, defaultValue);
    }

    public void setProperty(String property, String value) {
        this.frame.setProperty(property, value);
    }

    public FreeMindMain getFrame() {
        return this.frame;
    }

    public URL getResource(String resource) {
        return this.getFrame().getResource(resource);
    }

    public String getResourceString(String resource) {
        return this.frame.getResourceString(resource);
    }

    public ModeController getModeController() {
        return this.getMode().getModeController();
    }

    public MindMap getModel() {
        if (this.getMapModule() != null) {
            return this.getMapModule().getModel();
        }
        return null;
    }

    public MapView getView() {
        if (this.getMapModule() != null) {
            return this.getMapModule().getView();
        }
        System.err.println("[Freemind-Developer-Internal-Warning (do not write a bug report, please)]: Tried to get view without being able to get map module.");
        return null;
    }

    Set getModes() {
        return this.modescreator.getAllModes();
    }

    public Mode getMode() {
        return this.mode;
    }

    public String[] getZooms() {
        return zooms;
    }

    public MapModuleManager getMapModuleManager() {
        return this.mapModuleManager;
    }

    public LastOpenedList getLastOpenedList() {
        return this.lastOpened;
    }

    private MapModule getMapModule() {
        return this.getMapModuleManager().getMapModule();
    }

    private JToolBar getToolBar() {
        return this.toolbar;
    }

    public Font getFontThroughMap(Font font) {
        if (!this.fontMap.containsKey(font.toString())) {
            this.fontMap.put(font.toString(), font);
        }
        return (Font)this.fontMap.get(font.toString());
    }

    public void setAntialiasEdges(boolean antialiasEdges) {
        this.antialiasEdges = antialiasEdges;
    }

    public void setAntialiasAll(boolean antialiasAll) {
        this.antialiasAll = antialiasAll;
    }

    public boolean getAntialiasEdges() {
        return this.antialiasEdges;
    }

    public boolean getAntialiasAll() {
        return this.antialiasAll;
    }

    public Font getDefaultFont() {
        int fontSize = this.getDefaultFontSize();
        int fontStyle = this.getDefaultFontStyle();
        String fontFamily = this.getDefaultFontFamilyName();
        return this.getFontThroughMap(new Font(fontFamily, fontStyle, fontSize));
    }

    public String getDefaultFontFamilyName() {
        String fontFamily = this.getProperty("defaultfont");
        return fontFamily;
    }

    public int getDefaultFontStyle() {
        int fontStyle = Integer.parseInt(this.getFrame().getProperty("defaultfontstyle"));
        return fontStyle;
    }

    public int getDefaultFontSize() {
        int fontSize = Integer.parseInt(this.getFrame().getProperty("defaultfontsize"));
        return fontSize;
    }

    public static JColorChooser getCommonJColorChooser() {
        return colorChooser;
    }

    public static Color showCommonJColorChooserDialog(Component component, String title, Color initialColor) throws HeadlessException {
        JColorChooser pane = Controller.getCommonJColorChooser();
        pane.setColor(initialColor);
        ColorTracker ok = new ColorTracker(pane);
        JDialog dialog = JColorChooser.createDialog(component, title, true, pane, ok, null);
        dialog.addWindowListener(new Closer());
        dialog.addComponentListener(new DisposeOnClose());
        dialog.show();
        return ok.getColor();
    }

    public boolean changeToMode(String mode) {
        if (this.getMode() != null && mode.equals(((Object)this.getMode()).toString())) {
            return true;
        }
        Mode newmode = this.modescreator.getMode(mode);
        if (newmode == null) {
            this.errorMessage(this.getResourceString("mode_na") + ": " + mode);
            return false;
        }
        if (this.getMode() != null && this.getMode().getModeToolBar() != null) {
            this.toolbar.remove(this.getMode().getModeToolBar());
        }
        if (this.getMode() != null && this.getMode().getLeftToolBar() != null) {
            this.getFrame().getContentPane().remove(this.getMode().getLeftToolBar());
        }
        if (this.getMapModule() != null) {
            this.getMapModuleManager().setMapModule(null);
        }
        this.mode = newmode;
        if (this.getMode().getModeToolBar() != null) {
            this.toolbar.add(this.getMode().getModeToolBar());
            this.getMode().getModeToolBar().repaint();
        }
        if (this.getMode().getLeftToolBar() != null) {
            this.getFrame().getContentPane().add((Component)this.getMode().getLeftToolBar(), "West");
            this.getMode().getLeftToolBar().repaint();
        }
        this.toolbar.validate();
        this.toolbar.repaint();
        this.setTitle();
        this.getMode().activate();
        this.getFrame().getFreeMindMenuBar().updateMenus();
        if (this.getMapModule() == null) {
            this.setAllActions(false);
        }
        Object[] messageArguments = new Object[]{((Object)this.getMode()).toString()};
        MessageFormat formatter = new MessageFormat(this.getResourceString("mode_status"));
        this.getFrame().out(formatter.format(messageArguments));
        return true;
    }

    public void setMenubarVisible(boolean visible) {
        this.menubarVisible = visible;
        this.getFrame().getFreeMindMenuBar().setVisible(this.menubarVisible);
    }

    public void setToolbarVisible(boolean visible) {
        this.toolbarVisible = visible;
        this.toolbar.setVisible(this.toolbarVisible);
    }

    public JToolBar getToolbar() {
        return this.toolbar;
    }

    public void setLeftToolbarVisible(boolean visible) {
        if (this.getMode() != null && this.getMode().getLeftToolBar() != null) {
            this.leftToolbarVisible = visible;
            this.getMode().getLeftToolBar().setVisible(this.leftToolbarVisible);
        }
    }

    public NodeKeyListener getNodeKeyListener() {
        return this.nodeKeyListener;
    }

    public NodeMouseMotionListener getNodeMouseMotionListener() {
        return this.nodeMouseMotionListener;
    }

    public NodeMotionListener getNodeMotionListener() {
        return this.nodeMotionListener;
    }

    public MapMouseMotionListener getMapMouseMotionListener() {
        return this.mapMouseMotionListener;
    }

    public MapMouseWheelListener getMapMouseWheelListener() {
        return this.mapMouseWheelListener;
    }

    public NodeDragListener getNodeDragListener() {
        return this.nodeDragListener;
    }

    public NodeDropListener getNodeDropListener() {
        return this.nodeDropListener;
    }

    public void setFrame(FreeMindMain frame) {
        this.frame = frame;
    }

    void moveToRoot() {
        if (this.getMapModule() != null) {
            this.getView().moveToRoot();
        }
    }

    public void close(boolean force) {
        this.getMapModuleManager().close(force);
    }

    public void informationMessage(Object message) {
        JOptionPane.showMessageDialog(this.getFrame().getContentPane(), message.toString(), "FreeMind", 1);
    }

    public void informationMessage(Object message, JComponent component) {
        JOptionPane.showMessageDialog(component, message.toString(), "FreeMind", 1);
    }

    public void errorMessage(Object message) {
        String myMessage = "";
        if (message != null) {
            myMessage = message.toString();
        } else {
            myMessage = this.getResourceString("undefined_error");
            if (myMessage == null) {
                myMessage = "Undefined error";
            }
        }
        JOptionPane.showMessageDialog(this.getFrame().getContentPane(), myMessage, "FreeMind", 0);
    }

    public void errorMessage(Object message, JComponent component) {
        JOptionPane.showMessageDialog(component, message.toString(), "FreeMind", 0);
    }

    public void obtainFocusForSelected() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (Controller.this.getView() != null) {
                    Controller.this.getView().getSelected().requestFocus();
                } else {
                    Controller.this.getFrame().getFreeMindMenuBar().requestFocus();
                }
            }
        });
    }

    public void setZoom(float zoom) {
        this.getView().setZoom(zoom);
        ((MainToolBar)this.toolbar).setZoomComboBox(zoom);
        Object[] messageArguments = new Object[]{String.valueOf(zoom * 100.0f)};
        MessageFormat formatter = new MessageFormat(this.getResourceString("user_defined_zoom_status_bar"));
        this.getFrame().out(formatter.format(messageArguments));
    }

    public void setTitle() {
        Object[] messageArguments = new Object[]{((Object)this.getMode()).toString()};
        MessageFormat formatter = new MessageFormat(this.getResourceString("mode_title"));
        String title = formatter.format(messageArguments);
        if (this.getMapModule() != null) {
            title = this.getMapModule().toString() + " - " + title + (this.getMapModule().getModel().isReadOnly() ? " (" + this.getResourceString("read_only") + ")" : "");
        }
        this.getFrame().setTitle(title);
    }

    public void setAllActions(boolean enabled) {
        this.background.setEnabled(enabled);
        if (this.isPrintingAllowed) {
            this.print.setEnabled(enabled);
            this.printDirect.setEnabled(enabled);
            this.page.setEnabled(enabled);
        } else {
            this.print.setEnabled(false);
            this.printDirect.setEnabled(false);
            this.page.setEnabled(false);
        }
        this.close.setEnabled(enabled);
        this.moveToRoot.setEnabled(enabled);
        ((MainToolBar)this.getToolBar()).setAllActions(enabled);
    }

    private void quit() {
        String currentMapRestorable;
        String string = currentMapRestorable = this.getModel() != null ? this.getModel().getRestoreable() : null;
        while (this.getView() != null) {
            boolean closingNotCancelled = this.getMapModuleManager().close(false);
            if (closingNotCancelled) continue;
            return;
        }
        String lastOpenedString = this.lastOpened.save();
        this.setProperty("lastOpened", lastOpenedString);
        if (currentMapRestorable != null) {
            this.getFrame().setProperty("onStartIfNotSpecified", currentMapRestorable);
        }
        this.setProperty("toolbarVisible", this.toolbarVisible ? "true" : "false");
        this.setProperty("leftToolbarVisible", this.leftToolbarVisible ? "true" : "false");
        this.setProperty("antialiasEdges", this.antialiasEdges ? "true" : "false");
        this.setProperty("antialiasAll", this.antialiasAll ? "true" : "false");
        this.setProperty("appwindow_width", String.valueOf(this.getFrame().getWinWidth()));
        this.setProperty("appwindow_height", String.valueOf(this.getFrame().getWinHeight()));
        this.setProperty("appwindow_state", String.valueOf(this.getFrame().getWinState()));
        this.getFrame().saveProperties();
        System.exit(0);
    }

    private boolean acquirePrinterJobAndPageFormat() {
        if (this.printerJob == null) {
            try {
                this.printerJob = PrinterJob.getPrinterJob();
            }
            catch (SecurityException ex) {
                this.isPrintingAllowed = false;
                return false;
            }
        }
        if (this.pageFormat == null) {
            this.pageFormat = this.printerJob.defaultPage();
            if (Tools.safeEquals(this.getProperty("page_orientation"), "landscape")) {
                this.pageFormat.setOrientation(0);
            } else if (Tools.safeEquals(this.getProperty("page_orientation"), "portrait")) {
                this.pageFormat.setOrientation(1);
            } else if (Tools.safeEquals(this.getProperty("page_orientation"), "reverse_landscape")) {
                this.pageFormat.setOrientation(2);
            }
        }
        return true;
    }

    public static Collection getPropertyChangeListeners() {
        return Collections.unmodifiableCollection(propertyChangeListeners);
    }

    public static void addPropertyChangeListener(FreemindPropertyListener listener) {
        propertyChangeListeners.add(listener);
    }

    public WindowConfigurationStorage decorateDialog(JDialog dialog, String propertyName) {
        String unmarshalled = this.getProperty(propertyName);
        if (unmarshalled != null) {
            WindowConfigurationStorage storage = (WindowConfigurationStorage)this.unMarshall(unmarshalled);
            if (storage != null) {
                dialog.setLocation(storage.getX(), storage.getY());
                dialog.getRootPane().setPreferredSize(new Dimension(storage.getWidth(), storage.getHeight()));
            }
            return storage;
        }
        return null;
    }

    public void storeDialogPositions(JDialog dialog, WindowConfigurationStorage storage, String propertyName) {
        storage.setX(dialog.getX());
        storage.setY(dialog.getY());
        storage.setWidth(dialog.getWidth());
        storage.setHeight(dialog.getHeight());
        String marshalled = this.marshall(storage);
        this.setProperty(propertyName, marshalled);
    }

    public String marshall(XmlAction action) {
        try {
            StringWriter writer = new StringWriter();
            Marshaller m = JaxbTools.getInstance().createMarshaller();
            m.marshal((Object)action, (Writer)writer);
            String result = writer.toString();
            return result;
        }
        catch (JAXBException e) {
            logger.severe(e.toString());
            e.printStackTrace();
            return "";
        }
    }

    public XmlAction unMarshall(String inputString) {
        try {
            Unmarshaller u = JaxbTools.getInstance().createUnmarshaller();
            StringBuffer xmlStr = new StringBuffer(inputString);
            XmlAction doAction = (XmlAction)u.unmarshal((Source)new StreamSource(new StringReader(xmlStr.toString())));
            return doAction;
        }
        catch (JAXBException e) {
            e.printStackTrace();
            return null;
        }
    }

    public ObjectFactory getActionXmlFactory() {
        return this.actionXmlFactory;
    }

    static {
        colorChooser = new JColorChooser();
        zooms = new String[]{"25%", "50%", "75%", "100%", "150%", "200%", "300%", "400%"};
        JAVA_VERSION = System.getProperty("java.version");
        propertyChangeListeners = new Vector();
    }

    private class OpenFAQAction
    extends AbstractAction {
        Controller c;

        OpenFAQAction(Controller controller2) {
            super(controller2.getResourceString("FAQ"), new ImageIcon(controller2.getResource("images/Link.png")));
            this.c = controller2;
        }

        public void actionPerformed(ActionEvent e) {
            try {
                this.c.getFrame().openDocument(new URL("http://freemind.sourceforge.net/faq.html"));
            }
            catch (MalformedURLException ex) {
                this.c.errorMessage(this.c.getResourceString("url_error") + "\n" + ex);
            }
            catch (Exception ex) {
                this.c.errorMessage(ex);
            }
        }
    }

    private class OptionSelectionMechanismAction
    extends AbstractAction
    implements FreemindPropertyListener {
        Controller c;

        OptionSelectionMechanismAction(Controller controller2) {
            this.c = controller2;
            Controller.addPropertyChangeListener(this);
        }

        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            this.changeSelection(command);
        }

        private void changeSelection(String command) {
            Controller.this.setProperty("selection_method", command);
            NodeMouseMotionListener.updateSelectionMethod(this.c);
            String statusBarString = this.c.getResourceString(command);
            if (statusBarString != null) {
                this.c.getFrame().out(statusBarString);
            }
        }

        public void propertyChanged(String propertyName, String newValue, String oldValue) {
            if (propertyName.equals("selection_method")) {
                this.changeSelection(newValue);
            }
        }
    }

    private class OptionHTMLExportFoldingAction
    extends AbstractAction {
        OptionHTMLExportFoldingAction(Controller controller2) {
        }

        public void actionPerformed(ActionEvent e) {
            Controller.this.setProperty("html_export_folding", e.getActionCommand());
        }
    }

    public class OptionAntialiasAction
    extends AbstractAction
    implements FreemindPropertyListener {
        OptionAntialiasAction(Controller controller2) {
            Controller.addPropertyChangeListener(this);
        }

        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            this.changeAntialias(command);
        }

        public void changeAntialias(String command) {
            if (command == null) {
                return;
            }
            if (command.equals("antialias_none")) {
                Controller.this.setAntialiasEdges(false);
                Controller.this.setAntialiasAll(false);
            }
            if (command.equals("antialias_edges")) {
                Controller.this.setAntialiasEdges(true);
                Controller.this.setAntialiasAll(false);
            }
            if (command.equals("antialias_all")) {
                Controller.this.setAntialiasEdges(false);
                Controller.this.setAntialiasAll(true);
            }
            if (Controller.this.getView() != null) {
                Controller.this.getView().repaint();
            }
        }

        public void propertyChanged(String propertyName, String newValue, String oldValue) {
            if (propertyName.equals("antialias")) {
                this.changeAntialias(newValue);
            }
        }
    }

    private class BackgroundAction
    extends AbstractAction {
        BackgroundAction(Controller controller2, Icon icon) {
            super(controller2.getResourceString("background"), icon);
            Controller.addPropertyChangeListener(new FreemindPropertyListener(){

                public void propertyChanged(String propertyName, String newValue, String oldValue) {
                    if (propertyName.equals("standardbackgroundcolor")) {
                        Controller.this.getModel().setBackgroundColor(Tools.xmlToColor(newValue));
                    }
                }
            });
        }

        public void actionPerformed(ActionEvent e) {
            Color color = Controller.showCommonJColorChooserDialog(Controller.this.getView(), Controller.this.getResourceString("choose_background_color"), Controller.this.getView().getBackground());
            Controller.this.getModel().setBackgroundColor(color);
        }
    }

    private class BackgroundSwatch
    extends ColorSwatch {
        private BackgroundSwatch() {
        }

        Color getColor() {
            return Controller.this.getModel().getBackgroundColor();
        }
    }

    public class PropertyAction
    extends AbstractAction {
        private final Controller controller;

        public PropertyAction(Controller controller2) {
            super(controller2.getResourceString("property_dialog"));
            this.controller = controller2;
        }

        public void actionPerformed(ActionEvent arg0) {
            JDialog dialog = new JDialog((Frame)Controller.this.getFrame().getJFrame(), true);
            dialog.setResizable(true);
            dialog.setUndecorated(false);
            final OptionPanel options = new OptionPanel(Controller.this.getFrame(), dialog, new OptionPanel.OptionPanelFeedback(){

                public void writeProperties(Properties props) {
                    Vector<Object> sortedKeys = new Vector<Object>();
                    sortedKeys.addAll(props.keySet());
                    Collections.sort(sortedKeys);
                    HashMap<String, String> oldProperties = new HashMap<String, String>();
                    Iterator i = sortedKeys.iterator();
                    while (i.hasNext()) {
                        String newProperty;
                        String key = (String)i.next();
                        String oldProperty = PropertyAction.this.controller.getProperty(key);
                        if (oldProperty.equals(newProperty = props.getProperty(key))) continue;
                        oldProperties.put(key, oldProperty);
                        PropertyAction.this.controller.setProperty(key, newProperty);
                    }
                    i = Controller.getPropertyChangeListeners().iterator();
                    while (i.hasNext()) {
                        FreemindPropertyListener listener = (FreemindPropertyListener)i.next();
                        Iterator j = oldProperties.keySet().iterator();
                        while (j.hasNext()) {
                            String key = (String)j.next();
                            listener.propertyChanged(key, PropertyAction.this.controller.getProperty(key), (String)oldProperties.get(key));
                        }
                    }
                    if (oldProperties.size() > 0) {
                        JOptionPane.showMessageDialog(Controller.this.getFrame().getContentPane(), Controller.this.getResourceString("option_changes_may_require_restart"));
                        PropertyAction.this.controller.getFrame().saveProperties();
                    }
                }
            });
            options.buildPanel();
            options.setProperties(Controller.this.getFrame().getProperties());
            dialog.setTitle("Freemind Properties");
            dialog.setDefaultCloseOperation(2);
            dialog.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent event) {
                    options.closeWindow();
                }
            });
            AbstractAction action = new AbstractAction(){

                public void actionPerformed(ActionEvent arg0) {
                    options.closeWindow();
                }
            };
            action.putValue("Name", "end_dialog");
            dialog.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke("ESCAPE"), action.getValue("Name"));
            dialog.getRootPane().getActionMap().put(action.getValue("Name"), action);
            dialog.pack();
            dialog.setVisible(true);
        }
    }

    protected class ZoomOutAction
    extends AbstractAction {
        public ZoomOutAction(Controller controller2) {
            super(controller2.getResourceString("zoom_out"));
        }

        public void actionPerformed(ActionEvent e) {
            logger.info("ZoomOutAction actionPerformed");
            ((MainToolBar)Controller.this.toolbar).zoomOut();
        }
    }

    protected class ZoomInAction
    extends AbstractAction {
        public ZoomInAction(Controller controller2) {
            super(controller2.getResourceString("zoom_in"));
        }

        public void actionPerformed(ActionEvent e) {
            logger.info("ZoomInAction actionPerformed");
            ((MainToolBar)Controller.this.toolbar).zoomIn();
        }
    }

    private class ToggleLeftToolbarAction
    extends AbstractAction {
        ToggleLeftToolbarAction(Controller controller2) {
            super(controller2.getResourceString("toggle_left_toolbar"));
            this.setEnabled(true);
        }

        public void actionPerformed(ActionEvent event) {
            Controller.this.leftToolbarVisible = !Controller.this.leftToolbarVisible;
            Controller.this.setLeftToolbarVisible(Controller.this.leftToolbarVisible);
        }
    }

    private class ToggleToolbarAction
    extends AbstractAction {
        ToggleToolbarAction(Controller controller2) {
            super(controller2.getResourceString("toggle_toolbar"));
            this.setEnabled(true);
        }

        public void actionPerformed(ActionEvent event) {
            Controller.this.toolbarVisible = !Controller.this.toolbarVisible;
            Controller.this.setToolbarVisible(Controller.this.toolbarVisible);
        }
    }

    private class ToggleMenubarAction
    extends AbstractAction {
        ToggleMenubarAction(Controller controller2) {
            super(controller2.getResourceString("toggle_menubar"));
            this.setEnabled(true);
        }

        public void actionPerformed(ActionEvent event) {
            Controller.this.menubarVisible = !Controller.this.menubarVisible;
            Controller.this.setMenubarVisible(Controller.this.menubarVisible);
        }
    }

    private class MoveToRootAction
    extends AbstractAction {
        MoveToRootAction(Controller controller2) {
            super(controller2.getResourceString("move_to_root"));
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent event) {
            Controller.this.moveToRoot();
        }
    }

    private class NavigationNextMapAction
    extends AbstractAction {
        NavigationNextMapAction(Controller controller2) {
            super(controller2.getResourceString("next_map"), new ImageIcon(Controller.this.getResource("images/1rightarrow.png")));
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent event) {
            Controller.this.mapModuleManager.nextMapModule();
        }
    }

    private class NavigationPreviousMapAction
    extends AbstractAction {
        NavigationPreviousMapAction(Controller controller2) {
            super(controller2.getResourceString("previous_map"), new ImageIcon(Controller.this.getResource("images/1leftarrow.png")));
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent event) {
            Controller.this.mapModuleManager.previousMapModule();
        }
    }

    private class HistoryNextMapAction
    extends AbstractAction {
        HistoryNextMapAction(Controller controller2) {
            super(controller2.getResourceString("next_map"), new ImageIcon(Controller.this.getResource("images/Forward24.gif")));
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent event) {
            Controller.this.history.nextMap();
        }
    }

    private class HistoryPreviousMapAction
    extends AbstractAction {
        HistoryPreviousMapAction(Controller controller2) {
            super(controller2.getResourceString("previous_map"), new ImageIcon(Controller.this.getResource("images/Back24.gif")));
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent event) {
            Controller.this.history.previousMap();
        }
    }

    private class LicenseAction
    extends AbstractAction {
        Controller controller;

        LicenseAction(Controller controller2) {
            super(controller2.getResourceString("license"));
            this.controller = controller2;
        }

        public void actionPerformed(ActionEvent e) {
            JOptionPane.showMessageDialog(Controller.this.getView(), this.controller.getResourceString("license_text"));
        }
    }

    private class AboutAction
    extends AbstractAction {
        Controller controller;

        AboutAction(Controller controller2) {
            super(controller2.getResourceString("about"));
            this.controller = controller2;
        }

        public void actionPerformed(ActionEvent e) {
            JOptionPane.showMessageDialog(Controller.this.getFrame().getViewport(), this.controller.getResourceString("about_text") + "0.8.1");
        }
    }

    private class DocumentationAction
    extends AbstractAction {
        Controller controller;

        DocumentationAction(Controller controller2) {
            super(controller2.getResourceString("documentation"));
            this.controller = controller2;
        }

        public void actionPerformed(ActionEvent e) {
            Controller.this.changeToMode("Browse");
        }
    }

    private class PageAction
    extends AbstractAction {
        Controller controller;

        PageAction(Controller controller2) {
            super(controller2.getResourceString("page"));
            this.controller = controller2;
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            if (!Controller.this.acquirePrinterJobAndPageFormat()) {
                return;
            }
            final JDialog dialog = new JDialog((JFrame)((Object)Controller.this.getFrame()), Controller.this.getResourceString("printing_settings"), true);
            JCheckBox fitToPage = new JCheckBox(Controller.this.getResourceString("fit_to_page"), Tools.safeEquals("true", Controller.this.getProperty("fit_to_page")));
            JLabel userZoomL = new JLabel(Controller.this.getResourceString("user_zoom"));
            final JTextField userZoom = new JTextField(Controller.this.getProperty("user_zoom"), 3);
            userZoom.setEditable(!fitToPage.isSelected());
            JButton okButton = new JButton(Controller.this.getResourceString("ok"));
            final Tools.IntHolder eventSource = new Tools.IntHolder();
            JPanel panel = new JPanel();
            GridBagLayout gridbag = new GridBagLayout();
            GridBagConstraints c = new GridBagConstraints();
            eventSource.setValue(0);
            okButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    eventSource.setValue(1);
                    dialog.dispose();
                }
            });
            fitToPage.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    userZoom.setEditable(e.getStateChange() == 2);
                }
            });
            c.gridx = 0;
            c.gridy = 0;
            c.gridwidth = 2;
            gridbag.setConstraints(fitToPage, c);
            panel.add(fitToPage);
            c.gridy = 1;
            c.gridwidth = 1;
            gridbag.setConstraints(userZoomL, c);
            panel.add(userZoomL);
            c.gridx = 1;
            c.gridwidth = 1;
            gridbag.setConstraints(userZoom, c);
            panel.add(userZoom);
            c.gridy = 2;
            c.gridx = 0;
            c.gridwidth = 3;
            c.insets = new Insets(10, 0, 0, 0);
            gridbag.setConstraints(okButton, c);
            panel.add(okButton);
            panel.setLayout(gridbag);
            dialog.setDefaultCloseOperation(2);
            dialog.setContentPane(panel);
            dialog.setLocationRelativeTo((JFrame)((Object)Controller.this.getFrame()));
            dialog.getRootPane().setDefaultButton(okButton);
            dialog.pack();
            dialog.show();
            if (eventSource.getValue() != 1) {
                return;
            }
            Controller.this.setProperty("user_zoom", userZoom.getText());
            Controller.this.setProperty("fit_to_page", fitToPage.isSelected() ? "true" : "false");
            Controller.this.pageFormat = Controller.this.printerJob.pageDialog(Controller.this.pageFormat);
            if (Controller.this.pageFormat.getOrientation() == 0) {
                Controller.this.setProperty("page_orientation", "landscape");
            } else if (Controller.this.pageFormat.getOrientation() == 1) {
                Controller.this.setProperty("page_orientation", "portrait");
            } else if (Controller.this.pageFormat.getOrientation() == 2) {
                Controller.this.setProperty("page_orientation", "reverse_landscape");
            }
        }
    }

    private class PrintAction
    extends AbstractAction {
        Controller controller;
        boolean isDlg;

        PrintAction(Controller controller2, boolean isDlg) {
            super(controller2.getResourceString("print"), new ImageIcon(Controller.this.getResource("images/fileprint.png")));
            this.controller = controller2;
            this.setEnabled(false);
            this.isDlg = isDlg;
        }

        public void actionPerformed(ActionEvent e) {
            if (!Controller.this.acquirePrinterJobAndPageFormat()) {
                return;
            }
            Controller.this.printerJob.setPrintable(Controller.this.getView(), Controller.this.pageFormat);
            if (!this.isDlg || Controller.this.printerJob.printDialog()) {
                Controller.this.getView().preparePrinting();
                try {
                    Controller.this.printerJob.print();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                Controller.this.getView().endPrinting();
            }
        }
    }

    public static class CloseAction
    extends AbstractAction {
        private final Controller controller;

        CloseAction(Controller controller) {
            super(controller.getResourceString("close"));
            this.controller = controller;
        }

        public void actionPerformed(ActionEvent e) {
            this.controller.close(false);
        }
    }

    private class QuitAction
    extends AbstractAction {
        QuitAction(Controller controller2) {
            super(controller2.getResourceString("quit"));
        }

        public void actionPerformed(ActionEvent e) {
            Controller.this.quit();
        }
    }

    protected class HistoryManager {
        private LinkedList historyList = new LinkedList();
        private int current;

        HistoryManager() {
        }

        void nextMap() {
        }

        void previousMap() {
        }

        void mapChanged(MapModule map) {
        }
    }

    static class DisposeOnClose
    extends ComponentAdapter
    implements Serializable {
        DisposeOnClose() {
        }

        public void componentHidden(ComponentEvent e) {
            Window w = (Window)e.getComponent();
            w.dispose();
        }
    }

    static class Closer
    extends WindowAdapter
    implements Serializable {
        Closer() {
        }

        public void windowClosing(WindowEvent e) {
            Window w = e.getWindow();
            w.hide();
        }
    }

    private static class ColorTracker
    implements ActionListener,
    Serializable {
        JColorChooser chooser;
        Color color;

        public ColorTracker(JColorChooser c) {
            this.chooser = c;
        }

        public void actionPerformed(ActionEvent e) {
            this.color = this.chooser.getColor();
        }

        public Color getColor() {
            return this.color;
        }
    }
}

