/*
 * Decompiled with CFR 0.152.
 */
package freemind.controller.actions.generated.instance.impl.runtime;

import com.sun.xml.bind.unmarshaller.Messages;
import com.sun.xml.bind.unmarshaller.Tracer;
import com.sun.xml.bind.util.AttributesImpl;
import freemind.controller.actions.generated.instance.impl.runtime.GrammarInfo;
import freemind.controller.actions.generated.instance.impl.runtime.SAXUnmarshallerHandler;
import freemind.controller.actions.generated.instance.impl.runtime.UnmarshallerImpl;
import freemind.controller.actions.generated.instance.impl.runtime.UnmarshallingContext;
import freemind.controller.actions.generated.instance.impl.runtime.UnmarshallingEventHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import javax.xml.bind.JAXBException;
import javax.xml.bind.UnmarshalException;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class SAXUnmarshallerHandlerImpl
implements SAXUnmarshallerHandler,
UnmarshallingContext {
    private boolean isUnmarshalInProgress = true;
    private boolean[] collectText = new boolean[16];
    private int collectTextTop = 0;
    private final GrammarInfo grammarInfo;
    private Object result;
    private UnmarshallingEventHandler[] handlers = new UnmarshallingEventHandler[16];
    private int[] mementos = new int[16];
    private int handlerLen = 0;
    private StringBuffer buffer = new StringBuffer();
    private String[] nsBind = new String[16];
    private int nsLen = 0;
    private int[] idxStack = new int[16];
    private int idxStackTop = 0;
    private final Stack attStack = new Stack();
    private Runnable[] patchers = null;
    private int patchersLen = 0;
    private Hashtable idmap = null;
    private Locator locator;
    private final UnmarshallerImpl parent;
    private boolean aborted = false;
    private Tracer tracer;

    public SAXUnmarshallerHandlerImpl(UnmarshallerImpl _parent, GrammarInfo _gi) {
        this.parent = _parent;
        this.grammarInfo = _gi;
        this.startPrefixMapping("", "");
    }

    public GrammarInfo getGrammarInfo() {
        return this.grammarInfo;
    }

    private final boolean shouldCollectText() {
        return this.collectText[this.collectTextTop];
    }

    public void startDocument() throws SAXException {
        this.result = null;
        this.handlerLen = 0;
        this.patchers = null;
        this.patchersLen = 0;
        this.aborted = false;
        this.isUnmarshalInProgress = true;
        this.collectTextTop = 0;
        this.attStack.clear();
    }

    public void endDocument() throws SAXException {
        this.runPatchers();
        this.isUnmarshalInProgress = false;
    }

    public void startElement(String uri, String local, String qname, Attributes atts) throws SAXException {
        uri = uri.intern();
        local = local.intern();
        qname = qname.intern();
        if (this.result == null) {
            UnmarshallingEventHandler unmarshaller = this.grammarInfo.createUnmarshaller(uri, local, this);
            if (unmarshaller == null) {
                throw new SAXParseException(Messages.format((String)"SAXUnmarshallerHandlerImpl.UnexpectedRootElement2", (Object)uri, (Object)local, (Object)this.computeExpectedRootElements()), this.getLocator());
            }
            this.result = unmarshaller.owner();
            this.pushContentHandler(unmarshaller, 0);
        }
        this.processText(true);
        this.getCurrentHandler().enterElement(uri, local, qname, atts);
    }

    public final void endElement(String uri, String local, String qname) throws SAXException {
        uri = uri.intern();
        local = local.intern();
        qname = qname.intern();
        this.processText(false);
        this.getCurrentHandler().leaveElement(uri, local, qname);
    }

    public Object getResult() throws UnmarshalException {
        if (this.isUnmarshalInProgress) {
            throw new IllegalStateException();
        }
        if (!this.aborted) {
            return this.result;
        }
        throw new UnmarshalException((String)null);
    }

    public void pushContentHandler(UnmarshallingEventHandler handler, int memento) {
        if (this.handlerLen == this.handlers.length) {
            UnmarshallingEventHandler[] h = new UnmarshallingEventHandler[this.handlerLen * 2];
            int[] m = new int[this.handlerLen * 2];
            System.arraycopy(this.handlers, 0, h, 0, this.handlerLen);
            System.arraycopy(this.mementos, 0, m, 0, this.handlerLen);
            this.handlers = h;
            this.mementos = m;
        }
        this.handlers[this.handlerLen] = handler;
        this.mementos[this.handlerLen] = memento;
        ++this.handlerLen;
    }

    public void popContentHandler() throws SAXException {
        --this.handlerLen;
        this.handlers[this.handlerLen] = null;
        this.getCurrentHandler().leaveChild(this.mementos[this.handlerLen]);
    }

    public UnmarshallingEventHandler getCurrentHandler() {
        return this.handlers[this.handlerLen - 1];
    }

    protected void consumeText(String str, boolean ignorable) throws SAXException {
        if (ignorable && str.trim().length() == 0) {
            return;
        }
        this.getCurrentHandler().text(str);
    }

    private void processText(boolean ignorable) throws SAXException {
        if (this.shouldCollectText()) {
            this.consumeText(this.buffer.toString(), ignorable);
        }
        if (this.buffer.length() < 1024) {
            this.buffer.setLength(0);
        } else {
            this.buffer = new StringBuffer();
        }
    }

    public final void characters(char[] buf, int start, int len) {
        if (this.shouldCollectText()) {
            this.buffer.append(buf, start, len);
        }
    }

    public final void ignorableWhitespace(char[] buf, int start, int len) {
        this.characters(buf, start, len);
    }

    public void startPrefixMapping(String prefix, String uri) {
        if (this.nsBind.length == this.nsLen) {
            String[] n = new String[this.nsLen * 2];
            System.arraycopy(this.nsBind, 0, n, 0, this.nsLen);
            this.nsBind = n;
        }
        this.nsBind[this.nsLen++] = prefix;
        this.nsBind[this.nsLen++] = uri;
    }

    public void endPrefixMapping(String prefix) {
        this.nsLen -= 2;
    }

    public String resolveNamespacePrefix(String prefix) {
        if (prefix.equals("xml")) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        for (int i = this.idxStack[this.idxStackTop] - 2; i >= 0; i -= 2) {
            if (!prefix.equals(this.nsBind[i])) continue;
            return this.nsBind[i + 1];
        }
        return null;
    }

    public Iterator getPrefixes(String uri) {
        return Collections.unmodifiableList(this.getAllPrefixesInList(uri)).iterator();
    }

    private List getAllPrefixesInList(String uri) {
        ArrayList<String> a = new ArrayList<String>();
        if (uri.equals("http://www.w3.org/XML/1998/namespace")) {
            a.add("xml");
            return a;
        }
        if (uri.equals("http://www.w3.org/2000/xmlns/")) {
            a.add("xmlns");
            return a;
        }
        if (uri == null) {
            throw new IllegalArgumentException();
        }
        for (int i = this.nsLen - 2; i >= 0; i -= 2) {
            if (!uri.equals(this.nsBind[i + 1]) || !this.getNamespaceURI(this.nsBind[i]).equals(this.nsBind[i + 1])) continue;
            a.add(this.nsBind[i]);
        }
        return a;
    }

    public String getPrefix(String uri) {
        if (uri.equals("http://www.w3.org/XML/1998/namespace")) {
            return "xml";
        }
        if (uri.equals("http://www.w3.org/2000/xmlns/")) {
            return "xmlns";
        }
        if (uri == null) {
            throw new IllegalArgumentException();
        }
        for (int i = this.idxStack[this.idxStackTop] - 2; i >= 0; i -= 2) {
            if (!uri.equals(this.nsBind[i + 1]) || !this.getNamespaceURI(this.nsBind[i]).equals(this.nsBind[i + 1])) continue;
            return this.nsBind[i];
        }
        return null;
    }

    public String getNamespaceURI(String prefix) {
        if (prefix.equals("xmlns")) {
            return "http://www.w3.org/2000/xmlns/";
        }
        if (prefix == null) {
            throw new IllegalArgumentException();
        }
        return this.resolveNamespacePrefix(prefix);
    }

    public void pushAttributes(Attributes atts, boolean collectTextFlag) {
        Object[] newBuf;
        String v;
        AttributesImpl a = new AttributesImpl();
        for (int i = 0; i < atts.getLength(); ++i) {
            a.addAttribute(atts.getURI(i).intern(), atts.getLocalName(i).intern(), atts.getQName(i).intern(), atts.getType(i), atts.getValue(i));
        }
        int idx = a.getIndex("http://www.w3.org/2001/XMLSchema-instance", "nil");
        if (idx != -1 && ((v = a.getValue(idx).trim()).equals("false") || v.equals("0"))) {
            a.removeAttribute(idx);
        }
        this.attStack.push(a);
        if (++this.idxStackTop == this.idxStack.length) {
            newBuf = new int[this.idxStack.length * 2];
            System.arraycopy(this.idxStack, 0, newBuf, 0, this.idxStack.length);
            this.idxStack = newBuf;
        }
        this.idxStack[this.idxStackTop] = this.nsLen;
        if (++this.collectTextTop == this.collectText.length) {
            newBuf = new boolean[this.collectText.length * 2];
            System.arraycopy(this.collectText, 0, newBuf, 0, this.collectText.length);
            this.collectText = (boolean[])newBuf;
        }
        this.collectText[this.collectTextTop] = collectTextFlag;
    }

    public void popAttributes() {
        this.attStack.pop();
        --this.idxStackTop;
        --this.collectTextTop;
    }

    public Attributes getUnconsumedAttributes() {
        return (Attributes)this.attStack.peek();
    }

    public int getAttribute(String uri, String local) {
        if (this.attStack.isEmpty()) {
            return -1;
        }
        AttributesImpl a = (AttributesImpl)this.attStack.peek();
        return a.getIndexFast(uri, local);
    }

    public void consumeAttribute(int idx) throws SAXException {
        AttributesImpl a = (AttributesImpl)this.attStack.peek();
        String uri = a.getURI(idx);
        String local = a.getLocalName(idx);
        String qname = a.getQName(idx);
        String value = a.getValue(idx);
        a.removeAttribute(idx);
        this.getCurrentHandler().enterAttribute(uri, local, qname);
        this.consumeText(value, false);
        this.getCurrentHandler().leaveAttribute(uri, local, qname);
    }

    public String eatAttribute(int idx) throws SAXException {
        AttributesImpl a = (AttributesImpl)this.attStack.peek();
        String value = a.getValue(idx);
        a.removeAttribute(idx);
        return value;
    }

    public void addPatcher(Runnable job) {
        if (this.patchers == null) {
            this.patchers = new Runnable[32];
        }
        if (this.patchers.length == this.patchersLen) {
            Runnable[] buf = new Runnable[this.patchersLen * 2];
            System.arraycopy(this.patchers, 0, buf, 0, this.patchersLen);
            this.patchers = buf;
        }
        this.patchers[this.patchersLen++] = job;
    }

    private void runPatchers() {
        if (this.patchers != null) {
            for (int i = 0; i < this.patchersLen; ++i) {
                this.patchers[i].run();
            }
        }
    }

    public String addToIdTable(String id) {
        if (this.idmap == null) {
            this.idmap = new Hashtable();
        }
        this.idmap.put(id, this.getCurrentHandler().owner());
        return id;
    }

    public Object getObjectFromId(String id) {
        if (this.idmap == null) {
            return null;
        }
        return this.idmap.get(id);
    }

    public void skippedEntity(String name) {
    }

    public void processingInstruction(String target, String data) {
    }

    public void setDocumentLocator(Locator loc) {
        this.locator = loc;
    }

    public Locator getLocator() {
        return this.locator;
    }

    public void handleEvent(ValidationEvent event, boolean canRecover) throws SAXException {
        ValidationEventHandler eventHandler;
        try {
            eventHandler = this.parent.getEventHandler();
        }
        catch (JAXBException e) {
            throw new InternalError();
        }
        boolean recover = eventHandler.handleEvent(event);
        if (!recover) {
            this.aborted = true;
        }
        if (!canRecover || !recover) {
            throw new SAXException((Exception)new UnmarshalException(event.getMessage(), event.getLinkedException()));
        }
    }

    public String getBaseUri() {
        return null;
    }

    public boolean isUnparsedEntity(String s) {
        return true;
    }

    public boolean isNotation(String s) {
        return true;
    }

    public void setTracer(Tracer t) {
        this.tracer = t;
    }

    public Tracer getTracer() {
        if (this.tracer == null) {
            this.tracer = new Tracer.Standard();
        }
        return this.tracer;
    }

    private String computeExpectedRootElements() {
        String r = "";
        String[] probePoints = this.grammarInfo.getProbePoints();
        for (int i = 0; i < probePoints.length; i += 2) {
            if (!this.grammarInfo.recognize(probePoints[i], probePoints[i + 1])) continue;
            if (r.length() != 0) {
                r = r + ',';
            }
            r = r + "<{" + probePoints[i] + "}" + probePoints[i + 1] + ">";
        }
        return r;
    }
}

