/*
 * Decompiled with CFR 0.152.
 */
package freemind.controller.actions.generated.instance.impl.runtime;

import com.sun.xml.bind.ProxyGroup;
import com.sun.xml.bind.serializer.AbortSerializationException;
import com.sun.xml.bind.validator.Messages;
import freemind.controller.actions.generated.instance.impl.runtime.MSVValidator;
import freemind.controller.actions.generated.instance.impl.runtime.NamespaceContextImpl;
import freemind.controller.actions.generated.instance.impl.runtime.Util;
import freemind.controller.actions.generated.instance.impl.runtime.ValidatableObject;
import freemind.controller.actions.generated.instance.impl.runtime.XMLSerializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.ValidationEventLocator;
import javax.xml.bind.helpers.NotIdentifiableEventImpl;
import javax.xml.bind.helpers.ValidationEventImpl;
import javax.xml.bind.helpers.ValidationEventLocatorImpl;
import org.xml.sax.SAXException;

class ValidationContext {
    private final HashSet validatedObjects = new HashSet();
    private final NamespaceContextImpl nsContext = new NamespaceContextImpl(null);
    private final boolean validateID;
    private final HashSet IDs = new HashSet();
    private final HashMap IDREFs = new HashMap();
    private final ValidationEventHandler eventHandler;

    ValidationContext(ValidationEventHandler _eventHandler, boolean validateID) {
        this.eventHandler = _eventHandler;
        this.validateID = validateID;
    }

    public void validate(ValidatableObject vo) throws SAXException {
        if (this.validatedObjects.add(ProxyGroup.unwrap((Object)vo))) {
            MSVValidator.validate(this, vo);
        } else {
            this.reportEvent(vo, Messages.format((String)"ValidationContext.CycleDetected"));
        }
    }

    public NamespaceContextImpl getNamespaceContext() {
        return this.nsContext;
    }

    public String onID(XMLSerializable owner, String value) throws SAXException {
        if (!this.validateID) {
            return value;
        }
        if (!this.IDs.add(value)) {
            this.reportEvent(Util.toValidatableObject(owner), Messages.format((String)"ValidationContext.DuplicateId", (Object)value));
        }
        return value;
    }

    public String onIDREF(XMLSerializable referer, String value) throws SAXException {
        if (!this.validateID) {
            return value;
        }
        if (this.IDs.contains(value)) {
            return value;
        }
        this.IDREFs.put(value, referer);
        return value;
    }

    protected void reconcileIDs() throws SAXException {
        if (!this.validateID) {
            return;
        }
        Iterator itr = this.IDREFs.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry e = itr.next();
            if (this.IDs.contains(e.getKey())) continue;
            ValidatableObject source = (ValidatableObject)e.getValue();
            this.reportEvent(source, (ValidationEvent)new NotIdentifiableEventImpl(1, Messages.format((String)"ValidationContext.IdNotFound", e.getKey()), (ValidationEventLocator)new ValidationEventLocatorImpl((Object)source)));
        }
        this.IDREFs.clear();
    }

    public void reportEvent(ValidatableObject source, String formattedMessage) throws AbortSerializationException {
        this.reportEvent(source, (ValidationEvent)new ValidationEventImpl(1, formattedMessage, (ValidationEventLocator)new ValidationEventLocatorImpl((Object)source)));
    }

    public void reportEvent(ValidatableObject source, Exception nestedException) throws AbortSerializationException {
        this.reportEvent(source, (ValidationEvent)new ValidationEventImpl(1, nestedException.toString(), (ValidationEventLocator)new ValidationEventLocatorImpl((Object)source), (Throwable)nestedException));
    }

    public void reportEvent(ValidatableObject source, ValidationEvent event) throws AbortSerializationException {
        boolean r;
        try {
            r = this.eventHandler.handleEvent(event);
        }
        catch (RuntimeException re) {
            r = false;
        }
        if (!r) {
            throw new AbortSerializationException(event.getMessage());
        }
    }
}

