/*
 * Decompiled with CFR 0.152.
 */
package freemind.main;

import freemind.controller.Controller;
import freemind.controller.MenuBar;
import freemind.extensions.HookFactory;
import freemind.main.FreeMindMain;
import freemind.main.FreeMindSplash;
import freemind.main.Tools;
import freemind.modes.ModeController;
import freemind.preferences.FreemindPropertyListener;
import freemind.view.mindmapview.MapView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class FreeMind
extends JFrame
implements FreeMindMain {
    public static final String RESOURCE_LOOKANDFEEL = "lookandfeel";
    public static final String RESOURCE_ANTIALIAS = "antialias";
    public static final String RESOURCE_LANGUAGE = "language";
    public static final String RESOURCES_SELECTION_METHOD = "selection_method";
    public static final String RESOURCES_NODE_STYLE = "standardnodestyle";
    public static final String RESOURCES_ROOT_NODE_STYLE = "standardrootnodestyle";
    public static final String RESOURCES_NODE_COLOR = "standardnodecolor";
    public static final String RESOURCES_SELECTED_NODE_COLOR = "standardselectednodecolor";
    public static final String RESOURCES_EDGE_COLOR = "standardedgecolor";
    public static final String RESOURCES_EDGE_STYLE = "standardedgestyle";
    public static final String RESOURCES_CLOUD_COLOR = "standardcloudcolor";
    public static final String RESOURCES_LINK_COLOR = "standardlinkcolor";
    public static final String RESOURCES_BACKGROUND_COLOR = "standardbackgroundcolor";
    private static Logger logger = null;
    private static final String DEFAULT_LANGUAGE = "en";
    private HookFactory nodeHookFactory;
    public static final String version = "0.8.1";
    public URL defaultPropsURL;
    public static Properties props;
    private JScrollPane scrollPane = new JScrollPane();
    private MenuBar menuBar;
    private JLabel status;
    private Map filetypes;
    private File autoPropertiesFile;
    private File patternsFile;
    Controller c;
    private JPanel southPanel;
    private static PropertyResourceBundle languageResources;
    private PropertyResourceBundle defaultResources;
    static /* synthetic */ Class class$freemind$main$FreeMind;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FreeMind() {
        super("FreeMind");
        if (logger == null) {
            logger = this.getLogger((class$freemind$main$FreeMind == null ? (class$freemind$main$FreeMind = FreeMind.class$("freemind.main.FreeMind")) : class$freemind$main$FreeMind).getName());
        }
        FreeMindSplash splash = new FreeMindSplash(this);
        splash.setVisible(true);
        System.setProperty("apple.laf.useScreenMenuBar", "true");
        String propsLoc = "freemind.properties";
        this.defaultPropsURL = ClassLoader.getSystemResource(propsLoc);
        Properties def = new Properties();
        try {
            Properties user;
            InputStream in;
            block33: {
                in = this.defaultPropsURL.openStream();
                try {
                    def.load(in);
                }
                catch (Exception ex) {
                    System.err.println("Panic! Error while loading default properties.");
                }
                finally {
                    in.close();
                }
                props = def;
                user = new Properties(def);
                File userPropertiesFolder = new File(this.getFreemindDirectory());
                File userProperties = new File(userPropertiesFolder, def.getProperty("userproperties"));
                this.autoPropertiesFile = new File(userPropertiesFolder, def.getProperty("autoproperties"));
                this.patternsFile = new File(userPropertiesFolder, def.getProperty("patternsfile"));
                try {
                    String oldFolderName;
                    File oldFolder;
                    if (this.getProperty("properties_folder").startsWith(".") && (oldFolder = new File(oldFolderName = System.getProperty("user.home") + System.getProperty("file.separator") + this.getProperty("properties_folder").substring(1))).exists() && !userPropertiesFolder.exists()) {
                        System.out.println("Try to move the properties folder to .properties folder.");
                        oldFolder.renameTo(userPropertiesFolder);
                    }
                    if (!userPropertiesFolder.exists()) {
                        userPropertiesFolder.mkdir();
                    }
                    System.out.println();
                    System.out.println("Looking for user properties:");
                    System.out.println(userProperties);
                    System.out.println();
                    if (userProperties.exists()) {
                        in = new FileInputStream(userProperties);
                        user.load(in);
                        System.out.println("User properties found.");
                        break block33;
                    }
                    System.out.println("User properties not found. It will be automatically created.");
                    String output = new String("# automatically generated user.properties file.\n# generated by Freemind version 0.8.1\n# To change an option, please remove the '#' at the front of the corresponding line and restart freemind. Otherwise, the changes are ignored.\n");
                    String userPropsLoc = "user.properties";
                    URL userPropsURL = ClassLoader.getSystemResource(userPropsLoc);
                    InputStream inProp = userPropsURL.openStream();
                    try {
                        String line;
                        BufferedReader br = new BufferedReader(new InputStreamReader(inProp));
                        while ((line = br.readLine()) != null) {
                            output = output + "#" + line + "\n";
                        }
                        BufferedWriter fileout = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(userProperties)));
                        try {
                            fileout.write(output);
                            System.out.println("Done.");
                        }
                        catch (Exception ex) {
                            System.err.println(ex);
                        }
                        finally {
                            fileout.close();
                        }
                    }
                    catch (Exception ex) {
                        System.err.println(ex);
                    }
                    finally {
                        inProp.close();
                    }
                }
                catch (Exception ex) {
                    System.err.println(ex);
                }
                finally {
                    in.close();
                }
            }
            Properties auto = new Properties(user);
            try {
                in = new FileInputStream(this.autoPropertiesFile);
                auto.load(in);
            }
            catch (Exception ex) {
            }
            finally {
                in.close();
            }
            props = auto;
        }
        catch (Exception ex) {
            // empty catch block
        }
        this.updateLookAndFeel();
        ImageIcon icon = new ImageIcon(this.getResource("images/FreeMindWindowIcon.png"));
        this.setIconImage(icon.getImage());
        this.getContentPane().setLayout(new BorderLayout());
        this.c = new Controller(this);
        Controller.addPropertyChangeListener(new FreemindPropertyListener(){

            public void propertyChanged(String propertyName, String newValue, String oldValue) {
                if (propertyName.equals(FreeMind.RESOURCE_LANGUAGE)) {
                    languageResources = null;
                    FreeMind.this.getResources();
                }
            }
        });
        this.c.optionAntialiasAction.changeAntialias(this.getProperty(RESOURCE_ANTIALIAS));
        this.menuBar = new MenuBar(this.c);
        this.setJMenuBar(this.menuBar);
        int win_width = Integer.parseInt(props.getProperty("appwindow_width", "0"));
        int win_height = Integer.parseInt(props.getProperty("appwindow_height", "0"));
        win_width = win_width > 0 ? win_width : 640;
        win_height = win_height > 0 ? win_height : 440;
        this.getRootPane().setPreferredSize(new Dimension(win_width, win_height));
        this.getContentPane().add((Component)this.scrollPane, "Center");
        this.southPanel = new JPanel(new BorderLayout());
        this.status = new JLabel();
        this.southPanel.add((Component)this.status, "South");
        this.getContentPane().add((Component)this.southPanel, "South");
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                FreeMind.this.c.quit.actionPerformed(new ActionEvent(this, 0, "quit"));
            }

            public void windowActivated(WindowEvent e) {
                if (FreeMind.this.getView() != null && FreeMind.this.getView().getSelected() != null) {
                    FreeMind.this.getView().getSelected().requestFocus();
                }
            }
        });
        SwingUtilities.updateComponentTreeUI(this);
        this.c.changeToMode(this.getProperty("initial_mode"));
        splash.setVisible(false);
    }

    private void updateLookAndFeel() {
        try {
            String lookAndFeel = props.getProperty(RESOURCE_LOOKANDFEEL);
            if (lookAndFeel.equals("windows")) {
                UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
            } else if (lookAndFeel.equals("motif")) {
                UIManager.setLookAndFeel("com.sun.java.swing.plaf.motif.MotifLookAndFeel");
            } else if (lookAndFeel.equals("mac")) {
                UIManager.setLookAndFeel("javax.swing.plaf.mac.MacLookAndFeel");
            } else if (lookAndFeel.equals("metal")) {
                UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
            } else if (lookAndFeel.equals("gtk")) {
                UIManager.setLookAndFeel("com.sun.java.swing.plaf.gtk.GTKLookAndFeel");
            } else if (!lookAndFeel.equals("nothing")) {
                if (lookAndFeel.indexOf(46) != -1) {
                    UIManager.setLookAndFeel(lookAndFeel);
                } else {
                    System.out.println("Default (System) Look & Feel: " + UIManager.getSystemLookAndFeelClassName());
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                }
            }
        }
        catch (Exception ex) {
            System.err.println("Unable to set Look & Feel.");
        }
    }

    public boolean isApplet() {
        return false;
    }

    public File getPatternsFile() {
        return this.patternsFile;
    }

    public Container getViewport() {
        return this.scrollPane.getViewport();
    }

    public String getFreemindVersion() {
        return version;
    }

    public int getWinHeight() {
        return this.getRootPane().getHeight();
    }

    public int getWinWidth() {
        return this.getRootPane().getWidth();
    }

    public int getWinState() {
        return this.getExtendedState();
    }

    public URL getResource(String name) {
        return ClassLoader.getSystemResource(name);
    }

    public String getProperty(String key) {
        return props.getProperty(key);
    }

    public int getIntProperty(String key, int defaultValue) {
        try {
            return Integer.parseInt(this.getProperty(key));
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }

    public Properties getProperties() {
        return props;
    }

    public void setProperty(String key, String value) {
        props.setProperty(key, value);
    }

    public String getFreemindDirectory() {
        return System.getProperty("user.home") + System.getProperty("file.separator") + this.getProperty("properties_folder");
    }

    public void saveProperties() {
        try {
            FileOutputStream out = new FileOutputStream(this.autoPropertiesFile);
            props.store(out, null);
            ((OutputStream)out).close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public MapView getView() {
        return this.c.getView();
    }

    public Controller getController() {
        return this.c;
    }

    public void setView(MapView view) {
        this.scrollPane.setViewportView(view);
        if (view != null) {
            view.setAutoscrolls(true);
        }
    }

    public MenuBar getFreeMindMenuBar() {
        return this.menuBar;
    }

    public void out(String msg) {
        this.status.setText(msg);
    }

    public void err(String msg) {
        this.status.setText(msg);
    }

    public void openDocument(URL url) throws Exception {
        String osName;
        String correctedUrl = new String(url.toExternalForm());
        if (url.getProtocol().equals("file")) {
            correctedUrl = correctedUrl.replace('\\', '/').replaceAll(" ", "%20");
        }
        if ((osName = System.getProperty("os.name")).substring(0, 3).equals("Win")) {
            String propertyString = new String("default_browser_command_windows");
            propertyString = osName.indexOf("9") != -1 || osName.indexOf("Me") != -1 ? propertyString + "_9x" : propertyString + "_nt";
            String browser_command = new String();
            String command = new String();
            try {
                Object[] messageArguments = new Object[]{url.toString()};
                MessageFormat formatter = new MessageFormat(this.getProperty(propertyString));
                browser_command = formatter.format(messageArguments);
                command = url.getProtocol().equals("file") ? "rundll32 url.dll,FileProtocolHandler " + Tools.urlGetFile(url) : (url.toString().startsWith("mailto:") ? "rundll32 url.dll,FileProtocolHandler " + url.toString() : browser_command);
                Runtime.getRuntime().exec(command);
            }
            catch (IOException x) {
                this.c.errorMessage("Could not invoke browser.\n\nFreemind excecuted the following statement on a command line:\n\"" + command + "\".\n\nYou may look at the user or default property called '" + propertyString + "'.");
                System.err.println("Caught: " + x);
            }
        } else if (osName.startsWith("Mac OS")) {
            String browser_command = new String();
            try {
                Object[] messageArguments = new Object[]{correctedUrl, url.toString()};
                MessageFormat formatter = new MessageFormat(this.getProperty("default_browser_command_mac"));
                browser_command = formatter.format(messageArguments);
                Runtime.getRuntime().exec(browser_command);
            }
            catch (IOException ex2) {
                this.c.errorMessage("Could not invoke browser.\n\nFreemind excecuted the following statement on a command line:\n\"" + browser_command + "\".\n\nYou may look at the user or default property called 'default_browser_command_mac'.");
                System.err.println("Caught: " + ex2);
            }
        } else {
            String browser_command = new String();
            try {
                Object[] messageArguments = new Object[]{correctedUrl, url.toString()};
                MessageFormat formatter = new MessageFormat(this.getProperty("default_browser_command_other_os"));
                browser_command = formatter.format(messageArguments);
                Runtime.getRuntime().exec(browser_command);
            }
            catch (IOException ex2) {
                this.c.errorMessage("Could not invoke browser.\n\nFreemind excecuted the following statement on a command line:\n\"" + browser_command + "\".\n\nYou may look at the user or default property called 'default_browser_command_other_os'.");
                System.err.println("Caught: " + ex2);
            }
        }
    }

    private String transpose(String input, char findChar, String replaceString) {
        String res = new String();
        for (int i = 0; i < input.length(); ++i) {
            char d = input.charAt(i);
            res = d == findChar ? res + replaceString : res + d;
        }
        return res;
    }

    public void setWaitingCursor(boolean waiting) {
        if (waiting) {
            this.getRootPane().getGlassPane().setCursor(Cursor.getPredefinedCursor(3));
            this.getRootPane().getGlassPane().setVisible(true);
        } else {
            this.getRootPane().getGlassPane().setCursor(Cursor.getPredefinedCursor(0));
            this.getRootPane().getGlassPane().setVisible(false);
        }
    }

    private String getProgramForFile(String type) {
        if (this.filetypes == null) {
            this.filetypes = new HashMap();
            String raw = this.getProperty("filetypes");
            if (raw == null || raw.equals("")) {
                return "";
            }
            StringTokenizer tokens = new StringTokenizer(raw, ",");
            while (tokens.hasMoreTokens()) {
                StringTokenizer pair = new StringTokenizer(tokens.nextToken(), ":");
                String key = pair.nextToken().trim().toLowerCase();
                String value = pair.nextToken().trim();
                this.filetypes.put(key, value);
            }
        }
        return (String)this.filetypes.get(type.trim().toLowerCase());
    }

    public ResourceBundle getResources() {
        if (languageResources == null) {
            try {
                String lang = this.getProperty(RESOURCE_LANGUAGE);
                if ((lang == null || lang.equals("automatic")) && this.getLanguageResources(lang = Locale.getDefault().getLanguage() + "_" + Locale.getDefault().getCountry()) == null && this.getLanguageResources(lang = Locale.getDefault().getLanguage()) == null) {
                    lang = DEFAULT_LANGUAGE;
                }
                languageResources = this.getLanguageResources(lang);
                this.defaultResources = this.getLanguageResources(DEFAULT_LANGUAGE);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                System.err.println("Error loading Resources");
                return null;
            }
        }
        return languageResources;
    }

    public String getResourceString(String resource) {
        try {
            return this.getResources().getString(resource);
        }
        catch (Exception ex) {
            System.err.println("Warning - resource string not found:" + resource);
            try {
                return this.defaultResources.getString(resource) + "[translate me]";
            }
            catch (Exception e) {
                System.err.println("Warning - resource string not found (even in english):" + resource);
                return resource;
            }
        }
    }

    private PropertyResourceBundle getLanguageResources(String lang) throws IOException {
        URL systemResource = ClassLoader.getSystemResource("Resources_" + lang + ".properties");
        if (systemResource == null) {
            return null;
        }
        InputStream in = systemResource.openStream();
        if (in == null) {
            return null;
        }
        PropertyResourceBundle bundle = new PropertyResourceBundle(in);
        in.close();
        return bundle;
    }

    public Logger getLogger(String forClass) {
        return Logger.getLogger(forClass);
    }

    public static void main(String[] args) {
        FreeMind frame = new FreeMind();
        frame.c.checkJavaVersion();
        ModeController ctrl = frame.c.getMode().getModeController();
        boolean fileLoaded = false;
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].toLowerCase().endsWith(".mm")) continue;
            if (!Tools.isAbsolutePath(args[i])) {
                args[i] = System.getProperty("user.dir") + System.getProperty("file.separator") + args[i];
            }
            try {
                ctrl.load(new File(args[i]));
                fileLoaded = true;
                continue;
            }
            catch (Exception ex) {
                System.err.println("File " + args[i] + "not found error");
            }
        }
        if (!fileLoaded && frame.getProperty("onStartIfNotSpecified") != null) {
            frame.c.getLastOpenedList().open(frame.getProperty("onStartIfNotSpecified"));
        }
        frame.pack();
        try {
            if (frame.getView() != null) {
                if (!EventQueue.isDispatchThread()) {
                    EventQueue.invokeAndWait(new Runnable(){

                        public void run() {
                        }
                    });
                }
                frame.getView().moveToRoot();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (Tools.safeEquals(frame.getProperty("toolbarVisible"), "false")) {
            frame.c.setToolbarVisible(false);
        }
        if (Tools.safeEquals(frame.getProperty("leftToolbarVisible"), "false")) {
            frame.c.setLeftToolbarVisible(false);
        }
        frame.setVisible(true);
        int win_state = Integer.parseInt(props.getProperty("appwindow_state", "0"));
        win_state = (win_state & 1) != 0 ? 0 : win_state;
        frame.setExtendedState(win_state);
    }

    public HookFactory getHookFactory() {
        if (this.nodeHookFactory == null) {
            this.nodeHookFactory = new HookFactory(this);
        }
        return this.nodeHookFactory;
    }

    public JPanel getSouthPanel() {
        return this.southPanel;
    }

    public JFrame getJFrame() {
        return this;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

