/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes.actions;

import freemind.controller.MindMapNodesSelection;
import freemind.controller.actions.ActionPair;
import freemind.controller.actions.ActorXml;
import freemind.controller.actions.generated.instance.CompoundAction;
import freemind.controller.actions.generated.instance.CutNodeAction;
import freemind.controller.actions.generated.instance.PasteNodeAction;
import freemind.controller.actions.generated.instance.TransferableContentType;
import freemind.controller.actions.generated.instance.XmlAction;
import freemind.modes.ControllerAdapter;
import freemind.modes.MindMapNode;
import freemind.modes.actions.PasteAction;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.xml.bind.JAXBException;

public class CutAction
extends AbstractAction
implements ActorXml {
    private String text;
    private final ControllerAdapter c;
    static /* synthetic */ Class class$freemind$controller$actions$generated$instance$CutNodeAction;

    public CutAction(ControllerAdapter c) {
        super(c.getText("cut"), new ImageIcon(c.getResource("images/editcut.png")));
        this.c = c;
        this.text = c.getText("cut");
        this.setEnabled(false);
        this.c.getActionFactory().registerActor(this, this.getDoActionClass());
    }

    public void actionPerformed(ActionEvent e) {
        Transferable copy = this.c.cut();
        this.c.getClipboard().setContents(copy, null);
        this.c.getController().obtainFocusForSelected();
    }

    public CutNodeAction getCutNodeAction(Transferable t, MindMapNode node) throws JAXBException {
        return this.getCutNodeAction(t, new PasteAction.NodeCoordinate(node, node.isLeft().getValue()));
    }

    public CutNodeAction getCutNodeAction(Transferable t, PasteAction.NodeCoordinate coord) throws JAXBException {
        CutNodeAction cutAction = this.c.getActionXmlFactory().createCutNodeAction();
        cutAction.setTransferableContent(this.getTransferableContent(t));
        cutAction.setNode(this.c.getNodeID(coord.target));
        cutAction.setAsSibling(coord.asSibling);
        cutAction.setIsLeft(coord.isLeft);
        return cutAction;
    }

    public Transferable cut(List nodeList) {
        this.c.sortNodesByDepth(nodeList);
        Transferable totalCopy = this.c.getModel().copy(nodeList, null);
        try {
            CompoundAction doAction = this.c.getActionXmlFactory().createCompoundAction();
            CompoundAction undo = this.c.getActionXmlFactory().createCompoundAction();
            Iterator i = nodeList.iterator();
            while (i.hasNext()) {
                MindMapNode node = (MindMapNode)i.next();
                if (node.getParentNode() == null) continue;
                Transferable copy = this.c.getModel().copy(node);
                PasteAction.NodeCoordinate coord = new PasteAction.NodeCoordinate(node, node.isLeft().getValue());
                CutNodeAction cutNodeAction = this.getCutNodeAction(copy, coord);
                doAction.getCompoundActionOrSelectNodeActionOrCutNodeAction().add(cutNodeAction);
                PasteNodeAction pasteNodeAction = null;
                pasteNodeAction = this.c.paste.getPasteNodeAction(copy, coord);
                undo.getCompoundActionOrSelectNodeActionOrCutNodeAction().add(0, pasteNodeAction);
            }
            if (doAction.getCompoundActionOrSelectNodeActionOrCutNodeAction().size() > 0) {
                this.c.getActionFactory().startTransaction(this.text);
                this.c.getActionFactory().executeAction(new ActionPair(doAction, undo));
                this.c.getActionFactory().endTransaction(this.text);
            }
            return totalCopy;
        }
        catch (JAXBException e) {
            e.printStackTrace();
            return totalCopy;
        }
    }

    public void act(XmlAction action) {
        CutNodeAction cutAction = (CutNodeAction)action;
        this.c.getModel().getLinkRegistry().clearCuttedNodeBuffer();
        PasteAction.NodeCoordinate coord = new PasteAction.NodeCoordinate(this.c.getNodeFromID(cutAction.getNode()), cutAction.isAsSibling(), cutAction.isIsLeft());
        MindMapNode selectedNode = coord.getNode();
        this.c.getModel().getLinkRegistry().cutNode(selectedNode);
        this.c.deleteChild.deleteWithoutUndo(selectedNode);
    }

    public TransferableContentType getTransferableContent(Transferable t) throws JAXBException {
        try {
            String textFromClipboard;
            TransferableContentType trans = this.c.getActionXmlFactory().createTransferableContentType();
            if (t.isDataFlavorSupported(MindMapNodesSelection.mindMapNodesFlavor)) {
                textFromClipboard = (String)t.getTransferData(MindMapNodesSelection.mindMapNodesFlavor);
                trans.setTransferable(textFromClipboard);
            }
            if (t.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                textFromClipboard = (String)t.getTransferData(DataFlavor.stringFlavor);
                trans.setTransferableAsPlainText(textFromClipboard);
            }
            if (t.isDataFlavorSupported(MindMapNodesSelection.rtfFlavor)) {
                // empty if block
            }
            if (t.isDataFlavorSupported(MindMapNodesSelection.htmlFlavor)) {
                textFromClipboard = (String)t.getTransferData(MindMapNodesSelection.htmlFlavor);
                trans.setTransferableAsHtml(textFromClipboard);
            }
            if (t.isDataFlavorSupported(MindMapNodesSelection.fileListFlavor)) {
                List fileList = (List)t.getTransferData(MindMapNodesSelection.fileListFlavor);
                List listCopy = trans.getTransferableAsFileList();
                listCopy.clear();
                listCopy.addAll(fileList);
            }
            return trans;
        }
        catch (UnsupportedFlavorException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public Transferable getTransferable(TransferableContentType trans) {
        MindMapNodesSelection copy = new MindMapNodesSelection(trans.getTransferable(), trans.getTransferableAsPlainText(), trans.getTransferableAsRTF(), trans.getTransferableAsDrop(), trans.getTransferableAsHtml(), trans.getTransferableAsFileList());
        return copy;
    }

    public Class getDoActionClass() {
        return class$freemind$controller$actions$generated$instance$CutNodeAction == null ? (class$freemind$controller$actions$generated$instance$CutNodeAction = CutAction.class$("freemind.controller.actions.generated.instance.CutNodeAction")) : class$freemind$controller$actions$generated$instance$CutNodeAction;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

