/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes.actions;

import freemind.controller.actions.ActionPair;
import freemind.controller.actions.NodeActorXml;
import freemind.controller.actions.generated.instance.FontNodeAction;
import freemind.controller.actions.generated.instance.XmlAction;
import freemind.main.Tools;
import freemind.modes.ControllerAdapter;
import freemind.modes.MapAdapter;
import freemind.modes.MindMapNode;
import freemind.modes.ModeController;
import freemind.modes.NodeAdapter;
import freemind.modes.actions.NodeGeneralAction;
import java.awt.Font;
import javax.xml.bind.JAXBException;

public class FontFamilyAction
extends NodeGeneralAction
implements NodeActorXml {
    private String actionFont;
    static /* synthetic */ Class class$freemind$controller$actions$generated$instance$FontNodeAction;

    public FontFamilyAction(ControllerAdapter modeController) {
        super((ModeController)modeController, "font_family", null, (NodeActorXml)null);
        this.addActor(this);
        this.actionFont = modeController.getFrame().getProperty("defaultfont");
    }

    public void actionPerformed(String font) {
        this.actionFont = font;
        super.actionPerformed(null);
    }

    public ActionPair apply(MapAdapter model, MindMapNode selected) throws JAXBException {
        return this.getActionPair(selected, this.actionFont);
    }

    public Class getDoActionClass() {
        return class$freemind$controller$actions$generated$instance$FontNodeAction == null ? (class$freemind$controller$actions$generated$instance$FontNodeAction = FontFamilyAction.class$("freemind.controller.actions.generated.instance.FontNodeAction")) : class$freemind$controller$actions$generated$instance$FontNodeAction;
    }

    public void setFontFamily(MindMapNode node, String fontFamilyValue) {
        try {
            this.modeController.getActionFactory().startTransaction((String)this.getValue("Name"));
            this.modeController.getActionFactory().executeAction(this.getActionPair(node, fontFamilyValue));
            this.modeController.getActionFactory().endTransaction((String)this.getValue("Name"));
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
    }

    private ActionPair getActionPair(MindMapNode node, String fontFamilyValue) throws JAXBException {
        FontNodeAction fontFamilyAction = this.createFontNodeAction(node, fontFamilyValue);
        FontNodeAction undoFontFamilyAction = this.createFontNodeAction(node, node.getFontFamilyName());
        return new ActionPair(fontFamilyAction, undoFontFamilyAction);
    }

    private FontNodeAction createFontNodeAction(MindMapNode node, String fontValue) throws JAXBException {
        FontNodeAction fontFamilyAction = this.getActionXmlFactory().createFontNodeAction();
        fontFamilyAction.setNode(this.getNodeID(node));
        fontFamilyAction.setFont(fontValue);
        return fontFamilyAction;
    }

    public void act(XmlAction action) {
        if (action instanceof FontNodeAction) {
            FontNodeAction fontFamilyAction = (FontNodeAction)action;
            NodeAdapter node = this.getNodeFromID(fontFamilyAction.getNode());
            String fontFamily = fontFamilyAction.getFont();
            if (!Tools.safeEquals(node.getFontFamilyName(), fontFamily)) {
                node.estabilishOwnFont();
                node.setFont(this.modeController.getController().getFontThroughMap(new Font(fontFamily, node.getFont().getStyle(), node.getFont().getSize())));
                this.modeController.nodeChanged(node);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

