/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes.actions;

import freemind.controller.actions.FreemindAction;
import freemind.modes.MindMapNode;
import freemind.modes.ModeController;
import freemind.modes.NodeAdapter;
import java.awt.event.ActionEvent;

public class GotoLinkNodeAction
extends FreemindAction {
    MindMapNode source;
    private final ModeController controller;

    public GotoLinkNodeAction(ModeController controller, MindMapNode source) {
        super("goto_link_node_action", "images/Link.png", controller);
        this.controller = controller;
        this.source = source;
        if (source != null) {
            String adaptedText = source.getShortText(controller);
            this.putValue("Name", controller.getText("follow_link") + adaptedText);
            this.putValue("ShortDescription", ((Object)source).toString());
        }
    }

    public void actionPerformed(ActionEvent e) {
        this.controller.centerNode(this.source);
    }

    public String getShortTextForLink(MindMapNode node) {
        String adaptedText = node.getLink();
        if (adaptedText == null) {
            return null;
        }
        if (adaptedText.startsWith("#")) {
            try {
                NodeAdapter dest = this.controller.getNodeFromID(adaptedText.substring(1));
                return dest.getShortText(this.controller);
            }
            catch (Exception e) {
                return this.controller.getText("link_not_available_any_more");
            }
        }
        return adaptedText;
    }
}

