/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes.actions;

import freemind.controller.MindMapNodesSelection;
import freemind.controller.actions.ActionPair;
import freemind.controller.actions.ActorXml;
import freemind.controller.actions.generated.instance.CompoundAction;
import freemind.controller.actions.generated.instance.CutNodeAction;
import freemind.controller.actions.generated.instance.PasteNodeAction;
import freemind.controller.actions.generated.instance.XmlAction;
import freemind.main.Tools;
import freemind.main.XMLParseException;
import freemind.modes.ControllerAdapter;
import freemind.modes.MindMapNode;
import freemind.modes.NodeAdapter;
import freemind.modes.mindmapmode.MindMapNodeModel;
import freemind.modes.mindmapmode.MindMapXMLElement;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.xml.bind.JAXBException;

public class PasteAction
extends AbstractAction
implements ActorXml {
    public static final String NODESEPARATOR = "<nodeseparator>";
    private static Logger logger;
    private String text;
    private final ControllerAdapter c;
    static final Pattern nonLinkCharacter;
    static /* synthetic */ Class class$freemind$controller$actions$generated$instance$PasteNodeAction;

    public PasteAction(ControllerAdapter adapter) {
        super(adapter.getText("paste"), new ImageIcon(adapter.getResource("images/editpaste.png")));
        this.c = adapter;
        if (logger == null) {
            logger = this.c.getFrame().getLogger(this.getClass().getName());
        }
        this.text = adapter.getText("paste");
        this.setEnabled(false);
        this.c.getActionFactory().registerActor(this, this.getDoActionClass());
    }

    public void actionPerformed(ActionEvent e) {
        if (this.c.getClipboard() != null) {
            this.c.paste(this.c.getClipboard().getContents(this.c), this.c.getView().getSelected().getModel());
        }
    }

    public void act(XmlAction action) {
        PasteNodeAction pasteAction = (PasteNodeAction)action;
        this._paste(this.c.cut.getTransferable(pasteAction.getTransferableContent()), this.c.getNodeFromID(pasteAction.getNode()), pasteAction.isAsSibling(), pasteAction.isIsLeft());
    }

    public Class getDoActionClass() {
        return class$freemind$controller$actions$generated$instance$PasteNodeAction == null ? (class$freemind$controller$actions$generated$instance$PasteNodeAction = PasteAction.class$("freemind.controller.actions.generated.instance.PasteNodeAction")) : class$freemind$controller$actions$generated$instance$PasteNodeAction;
    }

    public PasteNodeAction getPasteNodeAction(Transferable t, NodeCoordinate coord) throws JAXBException {
        PasteNodeAction pasteAction = this.c.getActionXmlFactory().createPasteNodeAction();
        pasteAction.setNode(this.c.getNodeID(coord.target));
        pasteAction.setTransferableContent(this.c.cut.getTransferableContent(t));
        pasteAction.setAsSibling(coord.asSibling);
        pasteAction.setIsLeft(coord.isLeft);
        return pasteAction;
    }

    public void paste(MindMapNode node, MindMapNode parent) {
        if (node != null) {
            this.insertNodeInto(node, parent);
            this.c.nodeStructureChanged(parent);
        }
    }

    public void paste(Transferable t, MindMapNode target, boolean asSibling, boolean isLeft) {
        try {
            PasteNodeAction pasteAction = this.getPasteNodeAction(t, new NodeCoordinate(target, asSibling, isLeft));
            long amountOfCuts = 1L;
            DataFlavorHandler[] dataFlavorHandlerList = this.getFlavorHandlers();
            for (int i = 0; i < dataFlavorHandlerList.length; ++i) {
                DataFlavorHandler handler = dataFlavorHandlerList[i];
                DataFlavor flavor = handler.getDataFlavor();
                if (!t.isDataFlavorSupported(flavor)) continue;
                amountOfCuts = handler.getNumberOfObjects(t.getTransferData(flavor), t);
                break;
            }
            CompoundAction compound = this.c.getActionXmlFactory().createCompoundAction();
            for (long i = 0L; i < amountOfCuts; ++i) {
                CutNodeAction cutNodeAction = this.c.cut.getCutNodeAction(t, new NodeCoordinate(target, asSibling, isLeft));
                compound.getCompoundActionOrSelectNodeActionOrCutNodeAction().add(cutNodeAction);
            }
            this.c.getActionFactory().startTransaction(this.text);
            this.c.getActionFactory().executeAction(new ActionPair(pasteAction, compound));
            this.c.getActionFactory().endTransaction(this.text);
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
        catch (UnsupportedFlavorException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void _paste(Transferable t, MindMapNode target, boolean asSibling, boolean isLeft) {
        if (t == null) {
            return;
        }
        try {
            DataFlavorHandler[] dataFlavorHandlerList = this.getFlavorHandlers();
            for (int i = 0; i < dataFlavorHandlerList.length; ++i) {
                DataFlavorHandler handler = dataFlavorHandlerList[i];
                DataFlavor flavor = handler.getDataFlavor();
                if (!t.isDataFlavorSupported(flavor)) continue;
                handler.paste(t.getTransferData(flavor), target, asSibling, isLeft, t);
                break;
            }
            this.c.nodeStructureChanged((MindMapNode)(asSibling ? target.getParent() : target));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.c.getFrame().setWaitingCursor(false);
    }

    private DataFlavorHandler[] getFlavorHandlers() {
        DataFlavorHandler[] dataFlavorHandlerList = new DataFlavorHandler[]{new FileListFlavorHandler(), new MindMapNodesFlavorHandler(), new HtmlFlavorHandler(), new StringFlavorHandler()};
        return dataFlavorHandlerList;
    }

    private MindMapNodeModel pasteXMLWithoutRedisplay(String pasted, MindMapNode target) throws XMLParseException {
        return this.pasteXMLWithoutRedisplay(pasted, target, false);
    }

    public MindMapNodeModel pasteXMLWithoutRedisplay(String pasted, MindMapNode target, boolean asSibling) throws XMLParseException {
        try {
            MindMapXMLElement element = new MindMapXMLElement(this.c.getFrame());
            element.parseFromReader(new StringReader(pasted));
            MindMapNodeModel node = (MindMapNodeModel)element.getUserObject();
            element.processUnfinishedLinks(this.c.getModel().getLinkRegistry());
            if (asSibling) {
                MindMapNode parent = target.getParentNode();
                this.insertNodeInto(node, parent, parent.getChildPosition(target));
            } else {
                this.insertNodeInto(node, target);
            }
            this.c.invokeHooksRecursively(node, this.c.getModel());
            return node;
        }
        catch (IOException ee) {
            ee.printStackTrace();
            return null;
        }
    }

    private MindMapNode pasteStringWithoutRedisplay(String textFromClipboard, MindMapNode parent, boolean asSibling) {
        Pattern mailPattern = Pattern.compile("([^@ <>\\*']+@[^@ <>\\*']+)");
        String[] textLines = textFromClipboard.split("\n");
        if (textLines.length > 1) {
            this.c.getFrame().setWaitingCursor(true);
        }
        MindMapNode realParent = null;
        if (asSibling) {
            realParent = parent;
            parent = new MindMapNodeModel(this.c.getFrame());
        }
        ArrayList<MindMapNode> parentNodes = new ArrayList<MindMapNode>();
        ArrayList<Integer> parentNodesDepths = new ArrayList<Integer>();
        parentNodes.add(parent);
        parentNodesDepths.add(new Integer(-1));
        String[] linkPrefixes = new String[]{"http://", "ftp://", "https://"};
        MindMapNode pastedNode = null;
        block0: for (int i = 0; i < textLines.length; ++i) {
            int j;
            Matcher mailMatcher;
            int depth;
            String text = textLines[i];
            if ((text = text.replaceAll("\t", "        ")).matches(" *")) continue;
            for (depth = 0; depth < text.length() && text.charAt(depth) == ' '; ++depth) {
            }
            String visibleText = text.trim();
            if (visibleText.matches("^http://(www\\.)?[^ ]*$")) {
                visibleText = visibleText.replaceAll("^http://(www\\.)?", "").replaceAll("(/|\\.[^\\./\\?]*)$", "").replaceAll("((\\.[^\\./]*\\?)|\\?)[^/]*$", " ? ...").replaceAll("_|%20", " ");
                String[] textParts = visibleText.split("/");
                visibleText = "";
                for (int textPartIdx = 0; textPartIdx < textParts.length; ++textPartIdx) {
                    if (textPartIdx > 0) {
                        visibleText = visibleText + " > ";
                    }
                    visibleText = visibleText + (textPartIdx == 0 ? textParts[textPartIdx] : Tools.firstLetterCapitalized(textParts[textPartIdx].replaceAll("^~*", "")));
                }
            }
            MindMapNode node = this.c.newNode(visibleText);
            if (textLines.length == 1) {
                pastedNode = node;
            }
            if ((mailMatcher = mailPattern.matcher(visibleText)).find()) {
                node.setLink("mailto:" + mailMatcher.group());
            }
            for (j = 0; j < linkPrefixes.length; ++j) {
                int linkEnd;
                int linkStart = text.indexOf(linkPrefixes[j]);
                if (linkStart == -1) continue;
                for (linkEnd = linkStart; linkEnd < text.length() && !nonLinkCharacter.matcher(text.substring(linkEnd, linkEnd + 1)).matches(); ++linkEnd) {
                }
                node.setLink(text.substring(linkStart, linkEnd));
            }
            for (j = parentNodes.size() - 1; j >= 0; --j) {
                if (depth <= (Integer)parentNodesDepths.get(j)) continue;
                for (int k = j + 1; k < parentNodes.size(); ++k) {
                    parentNodes.remove(k);
                    parentNodesDepths.remove(k);
                }
                MindMapNode target = (MindMapNode)parentNodes.get(j);
                this.insertNodeIntoNoEvent(node, target);
                parentNodes.add(node);
                parentNodesDepths.add(new Integer(depth));
                continue block0;
            }
        }
        if (asSibling) {
            ListIterator i = parent.childrenUnfolded();
            while (i.hasNext()) {
                this.insertNodeIntoNoEvent((MindMapNode)i.next(), realParent, asSibling);
            }
            this.c.nodeStructureChanged(realParent.getParentNode());
        } else {
            this.c.nodeStructureChanged(parent);
        }
        return pastedNode;
    }

    private void insertNodeIntoNoEvent(MindMapNode node, MindMapNode target) {
        this.c.getModel().insertNodeIntoNoEvent(node, target);
    }

    private void insertNodeIntoNoEvent(MindMapNode node, MindMapNode realParent, boolean asSibling) {
        this.c.getModel().insertNodeIntoNoEvent(node, realParent, asSibling);
    }

    private void insertNodeInto(MindMapNodeModel node, MindMapNode parent, int i) {
        this.c.getModel().insertNodeInto(node, parent, i);
    }

    private void insertNodeInto(MindMapNode node, MindMapNode parent) {
        this.c.getModel().insertNodeInto(node, parent);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        nonLinkCharacter = Pattern.compile("[ \n()'\",;]");
    }

    private class StringFlavorHandler
    implements DataFlavorHandler {
        private StringFlavorHandler() {
        }

        public void paste(Object TransferData, MindMapNode target, boolean asSibling, boolean isLeft, Transferable t) throws UnsupportedFlavorException, IOException {
            String textFromClipboard = (String)t.getTransferData(DataFlavor.stringFlavor);
            PasteAction.this.pasteStringWithoutRedisplay(textFromClipboard, target, asSibling);
        }

        public long getNumberOfObjects(Object TransferData, Transferable transfer) {
            return ((String)TransferData).split("\n").length;
        }

        public DataFlavor getDataFlavor() {
            return DataFlavor.stringFlavor;
        }
    }

    private class HtmlFlavorHandler
    implements DataFlavorHandler {
        private HtmlFlavorHandler() {
        }

        public void paste(Object TransferData, MindMapNode target, boolean asSibling, boolean isLeft, Transferable t) throws UnsupportedFlavorException, IOException {
            String textFromClipboard = (String)TransferData;
            MindMapNode pastedNode = PasteAction.this.pasteStringWithoutRedisplay((String)t.getTransferData(DataFlavor.stringFlavor), target, asSibling);
            textFromClipboard = textFromClipboard.replaceAll("<!--.*?-->", "");
            String[] links = textFromClipboard.split("<[aA][^>]*[hH][rR][eE][fF]=\"");
            MindMapNode linkParentNode = null;
            URL referenceURL = null;
            boolean baseUrlCanceled = false;
            for (int i = 1; i < links.length; ++i) {
                String link = links[i].substring(0, links[i].indexOf("\""));
                String textWithHtml = links[i].replaceAll("^[^>]*>", "").replaceAll("</[aA]>[\\s\\S]*", "");
                String text = Tools.toXMLUnescapedText(textWithHtml.replaceAll("\\n", "").replaceAll("<[^>]*>", "").trim());
                if (text.equals("")) {
                    text = link;
                }
                URL linkURL = null;
                try {
                    linkURL = new URL(link);
                }
                catch (MalformedURLException ex) {
                    try {
                        if (referenceURL == null && !baseUrlCanceled) {
                            String referenceURLString = JOptionPane.showInputDialog(PasteAction.this.c.getText("enter_base_url"));
                            if (referenceURLString == null) {
                                baseUrlCanceled = true;
                            } else {
                                referenceURL = new URL(referenceURLString);
                            }
                        }
                        linkURL = new URL(referenceURL, link);
                    }
                    catch (MalformedURLException ex2) {
                        // empty catch block
                    }
                }
                if (linkURL == null) continue;
                if (links.length == 2 & pastedNode != null) {
                    ((MindMapNodeModel)pastedNode).setLink(linkURL.toString());
                    break;
                }
                if (linkParentNode == null) {
                    linkParentNode = PasteAction.this.c.newNode("Links");
                    PasteAction.this.insertNodeInto(linkParentNode, target);
                    ((NodeAdapter)linkParentNode).setBold(true);
                }
                MindMapNode linkNode = PasteAction.this.c.newNode(text);
                linkNode.setLink(linkURL.toString());
                PasteAction.this.insertNodeInto(linkNode, linkParentNode);
            }
        }

        public long getNumberOfObjects(Object TransferData, Transferable transfer) throws UnsupportedFlavorException, IOException {
            return ((String)transfer.getTransferData(DataFlavor.stringFlavor)).split("\n").length;
        }

        public DataFlavor getDataFlavor() {
            return MindMapNodesSelection.htmlFlavor;
        }
    }

    private class MindMapNodesFlavorHandler
    implements DataFlavorHandler {
        private MindMapNodesFlavorHandler() {
        }

        public void paste(Object TransferData, MindMapNode target, boolean asSibling, boolean isLeft, Transferable t) {
            String textFromClipboard = (String)TransferData;
            if (textFromClipboard != null) {
                String[] textLines = textFromClipboard.split(PasteAction.NODESEPARATOR);
                if (textLines.length > 1) {
                    PasteAction.this.c.getFrame().setWaitingCursor(true);
                }
                for (int i = 0; i < textLines.length; ++i) {
                    MindMapNodeModel newModel = PasteAction.this.pasteXMLWithoutRedisplay(textLines[i], target, asSibling);
                    newModel.setLeft(isLeft);
                }
            }
        }

        public long getNumberOfObjects(Object TransferData, Transferable transfer) {
            String textFromClipboard = (String)TransferData;
            if (textFromClipboard != null) {
                String[] textLines = textFromClipboard.split(PasteAction.NODESEPARATOR);
                return textLines.length;
            }
            return 0L;
        }

        public DataFlavor getDataFlavor() {
            return MindMapNodesSelection.mindMapNodesFlavor;
        }
    }

    private class FileListFlavorHandler
    implements DataFlavorHandler {
        private FileListFlavorHandler() {
        }

        public void paste(Object TransferData, MindMapNode target, boolean asSibling, boolean isLeft, Transferable t) {
            List fileList = (List)TransferData;
            ListIterator it = fileList.listIterator();
            while (it.hasNext()) {
                File file = (File)it.next();
                MindMapNode node = PasteAction.this.c.newNode(file.getName());
                node.setLink(file.getAbsolutePath());
                PasteAction.this.insertNodeIntoNoEvent(node, target, asSibling);
            }
            PasteAction.this.c.nodeStructureChanged((MindMapNode)(asSibling ? target.getParent() : target));
        }

        public long getNumberOfObjects(Object TransferData, Transferable transfer) {
            return ((List)TransferData).size();
        }

        public DataFlavor getDataFlavor() {
            return MindMapNodesSelection.fileListFlavor;
        }
    }

    private static interface DataFlavorHandler {
        public void paste(Object var1, MindMapNode var2, boolean var3, boolean var4, Transferable var5) throws UnsupportedFlavorException, IOException;

        public long getNumberOfObjects(Object var1, Transferable var2) throws UnsupportedFlavorException, IOException;

        public DataFlavor getDataFlavor();
    }

    public static class NodeCoordinate {
        public MindMapNode target;
        public boolean asSibling;
        public boolean isLeft;

        public NodeCoordinate(MindMapNode target, boolean asSibling, boolean isLeft) {
            this.target = target;
            this.asSibling = asSibling;
            this.isLeft = isLeft;
        }

        public MindMapNode getNode() {
            if (this.asSibling) {
                MindMapNode parentNode = this.target.getParentNode();
                return (MindMapNode)parentNode.getChildAt(parentNode.getChildPosition(this.target) - 1);
            }
            logger.finest("getChildCount = " + this.target.getChildCount() + ", target = " + this.target);
            return (MindMapNode)this.target.getChildAt(this.target.getChildCount() - 1);
        }

        public NodeCoordinate(MindMapNode node, boolean isLeft) {
            this.isLeft = isLeft;
            MindMapNode parentNode = node.getParentNode();
            int childPosition = parentNode.getChildPosition(node);
            if (childPosition == parentNode.getChildCount() - 1) {
                this.target = parentNode;
                this.asSibling = false;
            } else {
                this.target = (MindMapNode)parentNode.getChildAt(childPosition + 1);
                this.asSibling = true;
            }
        }
    }
}

