/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes.mindmapmode;

import freemind.controller.FreeMindToolBar;
import freemind.controller.StructuredMenuHolder;
import freemind.main.Tools;
import freemind.modes.mindmapmode.MindMapController;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.Action;
import javax.swing.JComboBox;
import javax.swing.JToolBar;
import javax.swing.plaf.basic.BasicComboBoxEditor;

public class MindMapToolBar
extends FreeMindToolBar {
    private static final String[] sizes = new String[]{"8", "10", "12", "14", "16", "18", "20", "24", "28"};
    private MindMapController c;
    private JComboBox fonts;
    private JComboBox size;
    private JToolBar buttonToolBar;
    private boolean fontSize_IgnoreChangeEvent = false;
    private boolean fontFamily_IgnoreChangeEvent = false;
    private ItemListener fontsListener;
    private ItemListener sizeListener;

    public MindMapToolBar(MindMapController controller) {
        this.c = controller;
        this.setRollover(true);
        this.fonts = new JComboBox(Tools.getAvailableFontFamilyNamesAsVector());
        this.size = new JComboBox<String>(sizes);
        this.buttonToolBar = new FreeMindToolBar();
        this.fontsListener = new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() != 1) {
                    return;
                }
                if (MindMapToolBar.this.fontFamily_IgnoreChangeEvent) {
                    return;
                }
                ((MindMapToolBar)MindMapToolBar.this).c.fontFamily.actionPerformed((String)e.getItem());
            }
        };
        this.fonts.addItemListener(this.fontsListener);
        this.sizeListener = new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() != 1) {
                    return;
                }
                if (MindMapToolBar.this.fontSize_IgnoreChangeEvent) {
                    return;
                }
                ((MindMapToolBar)MindMapToolBar.this).c.fontSize.actionPerformed((String)e.getItem());
            }
        };
        this.size.addItemListener(this.sizeListener);
    }

    public void update(StructuredMenuHolder holder) {
        this.removeAll();
        holder.updateMenus(this, "mindmapmode_toolbar/");
        this.fonts.setMaximumRowCount(9);
        this.add(this.fonts);
        this.fonts.setFocusable(false);
        this.size.setEditor(new BasicComboBoxEditor());
        this.size.setEditable(true);
        this.add(this.size);
        this.size.setFocusable(false);
        this.buttonToolBar.removeAll();
        this.buttonToolBar.setRollover(true);
        this.buttonToolBar.add(this.c.removeLastIconAction);
        this.buttonToolBar.add(this.c.removeAllIconsAction);
        this.buttonToolBar.addSeparator();
        for (int i = 0; i < this.c.iconActions.size(); ++i) {
            this.buttonToolBar.add((Action)this.c.iconActions.get(i));
        }
        this.buttonToolBar.setOrientation(1);
    }

    public void selectFontSize(String fontSize) {
        this.fontSize_IgnoreChangeEvent = true;
        this.size.setSelectedItem(fontSize);
        this.fontSize_IgnoreChangeEvent = false;
    }

    JToolBar getLeftToolBar() {
        return this.buttonToolBar;
    }

    public void selectFontName(String fontName) {
        this.fontFamily_IgnoreChangeEvent = true;
        this.fonts.setEditable(true);
        this.fonts.setSelectedItem(fontName);
        this.fonts.setEditable(false);
        this.fontFamily_IgnoreChangeEvent = false;
    }

    void setAllActions(boolean enabled) {
        this.fonts.setEnabled(enabled);
        this.size.setEnabled(enabled);
    }
}

