/*
 * Decompiled with CFR 0.152.
 */
package freemind.preferences.layout;

import freemind.preferences.layout.GrabKeyDialog;
import freemind.preferences.layout.KeyEventWorkaround;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.util.HashMap;
import java.util.Map;

public class KeyEventTranslator {
    static int c;
    static int a;
    static int m;
    static int s;
    private static Map transMap;
    static /* synthetic */ Class class$java$awt$event$KeyEvent;

    public static void addTranslation(Key key1, Key key2) {
        transMap.put(key1, key2);
    }

    public static Key translateKeyEvent(KeyEvent evt) {
        int modifiers = evt.getModifiers();
        Key returnValue = null;
        switch (evt.getID()) {
            case 401: {
                int keyCode = evt.getKeyCode();
                if (keyCode >= 48 && keyCode <= 57 || keyCode >= 65 && keyCode <= 90) {
                    returnValue = new Key(KeyEventTranslator.modifiersToString(modifiers), 0, Character.toUpperCase((char)keyCode));
                    break;
                }
                if (keyCode == 9) {
                    evt.consume();
                    returnValue = new Key(KeyEventTranslator.modifiersToString(modifiers), keyCode, '\u0000');
                    break;
                }
                if (keyCode == 32) {
                    if ((modifiers & 0xFFFFFFFE) == 0) {
                        returnValue = null;
                        break;
                    }
                    returnValue = new Key(KeyEventTranslator.modifiersToString(modifiers), 0, ' ');
                    break;
                }
                returnValue = new Key(KeyEventTranslator.modifiersToString(modifiers), keyCode, '\u0000');
                break;
            }
            case 400: {
                char ch = evt.getKeyChar();
                switch (ch) {
                    case '\b': 
                    case '\t': 
                    case '\n': {
                        return null;
                    }
                    case ' ': {
                        if ((modifiers & 0xFFFFFFFE) == 0) break;
                        return null;
                    }
                }
                int ignoreMods = 33;
                if ((modifiers & 0x20) == 0 && evt.getWhen() - KeyEventWorkaround.lastKeyTime < 750L && (KeyEventWorkaround.modifiers & ~ignoreMods) != 0) {
                    return null;
                }
                if (ch == ' ') {
                    returnValue = new Key(KeyEventTranslator.modifiersToString(modifiers), 0, ch);
                    break;
                }
                returnValue = new Key(null, 0, ch);
                break;
            }
            default: {
                return null;
            }
        }
        Key trans = (Key)transMap.get(returnValue);
        if (trans == null) {
            return returnValue;
        }
        return trans;
    }

    public static Key parseKey(String keyStroke) {
        int ch;
        String key;
        if (keyStroke == null) {
            return null;
        }
        int index = keyStroke.indexOf(43);
        int modifiers = 0;
        if (index != -1) {
            block8: for (int i = 0; i < index; ++i) {
                switch (Character.toUpperCase(keyStroke.charAt(i))) {
                    case 'A': {
                        modifiers |= a;
                        continue block8;
                    }
                    case 'C': {
                        modifiers |= c;
                        continue block8;
                    }
                    case 'M': {
                        modifiers |= m;
                        continue block8;
                    }
                    case 'S': {
                        modifiers |= s;
                    }
                }
            }
        }
        if ((key = keyStroke.substring(index + 1)).length() == 1) {
            return new Key(KeyEventTranslator.modifiersToString(modifiers), 0, key.charAt(0));
        }
        if (key.length() == 0) {
            return null;
        }
        if (key.equals("SPACE")) {
            return new Key(KeyEventTranslator.modifiersToString(modifiers), 0, ' ');
        }
        try {
            ch = (class$java$awt$event$KeyEvent == null ? (class$java$awt$event$KeyEvent = KeyEventTranslator.class$("java.awt.event.KeyEvent")) : class$java$awt$event$KeyEvent).getField("VK_".concat(key)).getInt(null);
        }
        catch (Exception e) {
            return null;
        }
        return new Key(KeyEventTranslator.modifiersToString(modifiers), ch, '\u0000');
    }

    public static void setModifierMapping(int c, int a, int m, int s) {
        int duplicateMapping = c & a | c & m | c & s | a & m | a & s | m & s;
        if ((duplicateMapping & 2) != 0) {
            throw new IllegalArgumentException("CTRL is mapped to more than one modifier");
        }
        if ((duplicateMapping & 8) != 0) {
            throw new IllegalArgumentException("ALT is mapped to more than one modifier");
        }
        if ((duplicateMapping & 4) != 0) {
            throw new IllegalArgumentException("META is mapped to more than one modifier");
        }
        if ((duplicateMapping & 1) != 0) {
            throw new IllegalArgumentException("SHIFT is mapped to more than one modifier");
        }
        KeyEventTranslator.c = c;
        KeyEventTranslator.a = a;
        KeyEventTranslator.m = m;
        KeyEventTranslator.s = s;
    }

    public static String getSymbolicModifierName(int mod) {
        if ((mod & c) != 0) {
            return "control";
        }
        if ((mod & a) != 0) {
            return "alt";
        }
        if ((mod & m) != 0) {
            return "meta";
        }
        if ((mod & s) != 0) {
            return "shift";
        }
        return "";
    }

    public static String modifiersToString(int mods) {
        StringBuffer buf = null;
        if ((mods & 2) != 0) {
            if (buf == null) {
                buf = new StringBuffer();
            } else {
                buf.append(" ");
            }
            buf.append(KeyEventTranslator.getSymbolicModifierName(2));
        }
        if ((mods & 8) != 0) {
            if (buf == null) {
                buf = new StringBuffer();
            } else {
                buf.append(" ");
            }
            buf.append(KeyEventTranslator.getSymbolicModifierName(8));
        }
        if ((mods & 4) != 0) {
            if (buf == null) {
                buf = new StringBuffer();
            } else {
                buf.append(" ");
            }
            buf.append(KeyEventTranslator.getSymbolicModifierName(4));
        }
        if ((mods & 1) != 0) {
            if (buf == null) {
                buf = new StringBuffer();
            } else {
                buf.append(" ");
            }
            buf.append(KeyEventTranslator.getSymbolicModifierName(1));
        }
        if (buf == null) {
            return null;
        }
        return buf.toString();
    }

    public static String getModifierString(InputEvent evt) {
        StringBuffer buf = new StringBuffer();
        if (evt.isControlDown()) {
            buf.append(KeyEventTranslator.getSymbolicModifierName(2));
        }
        if (evt.isAltDown()) {
            buf.append(KeyEventTranslator.getSymbolicModifierName(8));
        }
        if (evt.isMetaDown()) {
            buf.append(KeyEventTranslator.getSymbolicModifierName(4));
        }
        if (evt.isShiftDown()) {
            buf.append(KeyEventTranslator.getSymbolicModifierName(1));
        }
        return buf.length() == 0 ? null : buf.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        transMap = new HashMap();
        if (GrabKeyDialog.isMacOS()) {
            KeyEventTranslator.setModifierMapping(4, 2, 8, 1);
        } else {
            KeyEventTranslator.setModifierMapping(2, 8, 4, 1);
        }
    }

    public static class Key {
        public String modifiers;
        public int key;
        public char input;

        public Key(String modifiers, int key, char input) {
            this.modifiers = modifiers;
            this.key = key;
            this.input = input;
        }

        public int hashCode() {
            return this.key + this.input;
        }

        public boolean equals(Object o) {
            if (o instanceof Key) {
                Key k = (Key)o;
                if (this.modifiers.equals(k.modifiers) && this.key == k.key && this.input == k.input) {
                    return true;
                }
            }
            return false;
        }

        public String toString() {
            return (this.modifiers == null ? "" : this.modifiers) + "<" + Integer.toString(this.key, 16) + "," + Integer.toString(this.input, 16) + ">";
        }
    }
}

