/*
 * Decompiled with CFR 0.152.
 */
package freemind.preferences.layout;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.FormLayout;
import freemind.controller.Controller;
import freemind.controller.actions.generated.instance.OptionPanelWindowConfigurationStorage;
import freemind.controller.actions.generated.instance.OptionPanelWindowConfigurationStorageType;
import freemind.controller.actions.generated.instance.WindowConfigurationStorage;
import freemind.main.FreeMindMain;
import freemind.main.Tools;
import freemind.preferences.layout.GrabKeyDialog;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.xml.bind.JAXBException;

public class OptionPanel {
    private static final Color MARKED_BUTTON_COLOR = Color.BLUE;
    private Vector controls;
    private final JDialog frame;
    private HashMap tabButtonMap = new HashMap();
    private HashMap tabActionMap = new HashMap();
    private String selectedPanel = null;
    private static JColorChooser colorChooser;
    private final OptionPanelFeedback feedback;
    private static FreeMindMain fmMain;
    private static final String PREFERENCE_STORAGE_PROPERTY = "OptionPanel_Window_Properties";
    private static final String DEFAULT_LAYOUT_FORMAT = "right:max(40dlu;p), 4dlu, 120dlu, 7dlu";
    public static Vector changeListeners;
    private static String lastKey;

    public OptionPanel(FreeMindMain fm, JDialog frame, OptionPanelFeedback feedback) {
        if (fmMain == null) {
            fmMain = fm;
        }
        this.frame = frame;
        this.feedback = feedback;
        WindowConfigurationStorage storage = fm.getController().decorateDialog(frame, PREFERENCE_STORAGE_PROPERTY);
        if (storage == null) {
            frame.getRootPane().setPreferredSize(new Dimension(800, 600));
        } else if (storage instanceof OptionPanelWindowConfigurationStorageType) {
            OptionPanelWindowConfigurationStorageType oWindowSettings = (OptionPanelWindowConfigurationStorageType)storage;
            this.selectedPanel = oWindowSettings.getPanel();
        }
    }

    private static Properties getProperties() {
        OptionPanel.checkConnectionToFreeMindMain();
        return fmMain.getProperties();
    }

    public void setProperties(Properties properties) {
        Iterator i = this.controls.iterator();
        while (i.hasNext()) {
            PropertyControl control = (PropertyControl)i.next();
            if (!(control instanceof PropertyBean)) continue;
            PropertyBean bean = (PropertyBean)((Object)control);
            String value = properties.getProperty(bean.getLabel());
            bean.setValue(value);
        }
    }

    private Properties getOptionProperties() {
        Properties p = new Properties();
        Iterator i = this.controls.iterator();
        while (i.hasNext()) {
            PropertyControl control = (PropertyControl)i.next();
            if (!(control instanceof PropertyBean)) continue;
            PropertyBean bean = (PropertyBean)((Object)control);
            p.setProperty(bean.getLabel(), bean.getValue());
        }
        return p;
    }

    public void buildPanel() {
        FormLayout leftLayout = new FormLayout("80dlu", "");
        DefaultFormBuilder leftBuilder = new DefaultFormBuilder(leftLayout);
        CardLayout cardLayout = new CardLayout();
        JPanel rightStack = new JPanel(cardLayout);
        FormLayout rightLayout = null;
        DefaultFormBuilder rightBuilder = null;
        String lastTabName = null;
        this.controls = this.getControls();
        Iterator i = this.controls.iterator();
        while (i.hasNext()) {
            PropertyControl control = (PropertyControl)i.next();
            if (control instanceof NewTabProperty) {
                NewTabProperty newTab = (NewTabProperty)control;
                if (rightBuilder != null) {
                    rightStack.add((Component)rightBuilder.getPanel(), lastTabName);
                }
                rightLayout = new FormLayout(newTab.getDescription(), "");
                rightBuilder = new DefaultFormBuilder(rightLayout);
                rightBuilder.setDefaultDialogBorder();
                lastTabName = newTab.getLabel();
                JButton tabButton = new JButton(OptionPanel.getText(lastTabName));
                ChangeTabAction changeTabAction = new ChangeTabAction(cardLayout, rightStack, lastTabName);
                tabButton.addActionListener(changeTabAction);
                this.registerTabButton(tabButton, lastTabName, changeTabAction);
                leftBuilder.append((Component)tabButton);
                continue;
            }
            control.layout(rightBuilder);
        }
        rightStack.add((Component)rightBuilder.getPanel(), lastTabName);
        if (this.selectedPanel != null && this.tabActionMap.containsKey(this.selectedPanel)) {
            ((ChangeTabAction)this.tabActionMap.get(this.selectedPanel)).actionPerformed(null);
        }
        JSplitPane centralPanel = new JSplitPane(1, leftBuilder.getPanel(), new JScrollPane(rightStack));
        this.frame.getContentPane().add((Component)centralPanel, "Center");
        JButton cancelButton = new JButton(OptionPanel.getText("Cancel"));
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                OptionPanel.this.closeWindow();
            }
        });
        JButton okButton = new JButton(OptionPanel.getText("OK"));
        okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                OptionPanel.this.feedback.writeProperties(OptionPanel.this.getOptionProperties());
                OptionPanel.this.closeWindow();
            }
        });
        this.frame.getRootPane().setDefaultButton(okButton);
        this.frame.getContentPane().add((Component)ButtonBarFactory.buildOKCancelBar((JButton)cancelButton, (JButton)okButton), "South");
    }

    private static String getText(String string) {
        if (string == null) {
            return null;
        }
        OptionPanel.checkConnectionToFreeMindMain();
        return fmMain.getResourceString("OptionPanel." + string);
    }

    private static void checkConnectionToFreeMindMain() {
        if (fmMain == null) {
            throw new IllegalArgumentException("FreeMindMain not set yet.");
        }
    }

    private void registerTabButton(JButton tabButton, String name, ChangeTabAction changeTabAction) {
        this.tabButtonMap.put(name, tabButton);
        this.tabActionMap.put(name, changeTabAction);
        if (this.selectedPanel == null) {
            this.selectedPanel = name;
        }
    }

    private JButton getTabButton(String name) {
        return (JButton)this.tabButtonMap.get(name);
    }

    private Collection getAllButtons() {
        return this.tabButtonMap.values();
    }

    private Vector getControls() {
        Vector<PropertyControl> controls = new Vector<PropertyControl>();
        controls.add(new NewTabProperty("Environment"));
        controls.add(new SeparatorProperty("language"));
        controls.add(new ComboProperty("language.tooltip", "language", new String[]{"automatic", "cs", "de", "dk", "en", "es", "fr", "hu", "it", "ja", "kr", "lt", "nl", "no", "pl", "pt_BR", "pt_PT", "ru", "sl", "zh", "zh_CN"}));
        controls.add(new NextLineProperty());
        controls.add(new SeparatorProperty("files"));
        controls.add(new StringProperty(null, "last_opened_list_length"));
        controls.add(new BooleanProperty("experimental_file_locking_on.tooltip", "experimental_file_locking_on"));
        controls.add(new NextLineProperty());
        controls.add(new StringProperty(null, "userproperties"));
        controls.add(new StringProperty(null, "patternsfile"));
        controls.add(new StringProperty(null, "docmapurl_since_version_0_7_0"));
        controls.add(new StringProperty("browsemode_initial_map.tooltip", "browsemode_initial_map"));
        controls.add(new NextLineProperty());
        controls.add(new SeparatorProperty("automatic_save"));
        controls.add(new StringProperty("time_for_automatic_save.tooltip", "time_for_automatic_save"));
        controls.add(new BooleanProperty("delete_automatic_saves_at_exit.tooltip", "delete_automatic_saves_at_exit"));
        controls.add(new StringProperty("number_of_different_files_for_automatic_save.tooltip", "number_of_different_files_for_automatic_save"));
        controls.add(new StringProperty("path_to_automatic_saves.tooltip", "path_to_automatic_saves"));
        controls.add(new NewTabProperty("Defaults"));
        controls.add(new SeparatorProperty("default_styles"));
        controls.add(new ComboProperty("standardnodestyle.tooltip", "standardnodestyle", new String[]{"fork", "bubble", "as_parent", "combined"}));
        controls.add(new ComboProperty("standardrootnodestyle.tooltip", "standardrootnodestyle", new String[]{"fork", "bubble", "combined"}));
        controls.add(new NextLineProperty());
        controls.add(new SeparatorProperty("default_colors"));
        controls.add(new ColorProperty("standardnodecolor.tooltip", "standardnodecolor", "#000000"));
        controls.add(new ColorProperty("standardselectednodecolor.tooltip", "standardselectednodecolor", "#D2D2D2"));
        controls.add(new ColorProperty("standardedgecolor.tooltip", "standardedgecolor", "#808080"));
        controls.add(new ColorProperty("standardlinkcolor.tooltip", "standardlinkcolor", "#b0b0b0"));
        controls.add(new ColorProperty("standardbackgroundcolor.tooltip", "standardbackgroundcolor", "#ffffff"));
        controls.add(new ColorProperty("standardcloudcolor.tooltip", "standardcloudcolor", "#f0f0f0"));
        controls.add(new NextLineProperty());
        controls.add(new SeparatorProperty("default_fonts"));
        controls.add(new StringProperty("defaultfont.tooltip", "defaultfont"));
        controls.add(new StringProperty(null, "defaultfontstyle"));
        controls.add(new StringProperty(null, "defaultfontsize"));
        controls.add(new StringProperty("max_node_width.tooltip", "max_node_width"));
        controls.add(new NextLineProperty());
        controls.add(new SeparatorProperty("other_defaults"));
        controls.add(new ComboProperty("standardedgestyle.tooltip", "standardedgestyle", new String[]{"bezier", "linear"}));
        controls.add(new NewTabProperty("Appearance"));
        controls.add(new SeparatorProperty("look_and_feel"));
        UIManager.LookAndFeelInfo[] lafInfo = UIManager.getInstalledLookAndFeels();
        String[] lafNames = new String[lafInfo.length + 5];
        Vector<String> translatedLafNames = new Vector<String>();
        lafNames[0] = "default";
        translatedLafNames.add(OptionPanel.getText("default"));
        lafNames[1] = "metal";
        translatedLafNames.add(OptionPanel.getText("metal"));
        lafNames[2] = "windows";
        translatedLafNames.add(OptionPanel.getText("windows"));
        lafNames[3] = "motif";
        translatedLafNames.add(OptionPanel.getText("motif"));
        lafNames[4] = "gtk";
        translatedLafNames.add(OptionPanel.getText("gtk"));
        lafNames[5] = "nothing";
        translatedLafNames.add(OptionPanel.getText("nothing"));
        for (int i = 0; i < lafInfo.length; ++i) {
            String className;
            UIManager.LookAndFeelInfo info = lafInfo[i];
            lafNames[i + 5] = className = info.getClassName();
            translatedLafNames.add(info.getName());
        }
        controls.add(new ComboProperty("lookandfeel.tooltip", "lookandfeel", lafNames, translatedLafNames));
        controls.add(new NextLineProperty());
        controls.add(new SeparatorProperty("anti_alias"));
        controls.add(new ComboProperty("antialias.tooltip", "antialias", new String[]{"antialias_edges", "antialias_all", "antialias_none"}));
        controls.add(new NextLineProperty());
        controls.add(new SeparatorProperty("initial_map_size"));
        controls.add(new StringProperty("mapxsize.tooltip", "mapxsize"));
        controls.add(new StringProperty(null, "mapysize"));
        controls.add(new NextLineProperty());
        controls.add(new SeparatorProperty("hyperlink_types"));
        controls.add(new ComboProperty("links.tooltip", "links", new String[]{"relative", "absolute"}));
        controls.add(new NextLineProperty());
        controls.add(new SeparatorProperty("edit_long_node_window"));
        controls.add(new StringProperty("el__buttons_position.tooltip", "el__buttons_position"));
        controls.add(new BooleanProperty(null, "el__position_window_below_node"));
        controls.add(new StringProperty(null, "el__min_default_window_height"));
        controls.add(new StringProperty(null, "el__max_default_window_height"));
        controls.add(new StringProperty(null, "el__min_default_window_width"));
        controls.add(new StringProperty(null, "el__max_default_window_width"));
        controls.add(new BooleanProperty(null, "el__enter_confirms_by_default"));
        String form = "right:max(40dlu;p), 4dlu, 80dlu, 7dlu";
        controls.add(new NewTabProperty("Keystrokes", form + "," + form));
        controls.add(new SeparatorProperty("commands_for_the_program"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_newMap"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_open"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_save"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_saveAs"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_print"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_close"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_quit"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_option_dialog"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_export_to_html"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_export_branch_to_html"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_open_first_in_history"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_previousMap"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_nextMap"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_mode_MindMap"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_mode_Browse"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_mode_File"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_node_toggle_italic"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_node_toggle_boldface"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_node_toggle_underlined"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_node_toggle_cloud"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_undo"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_redo"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_delete_child"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_select_all"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_select_branch"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_zoom_out"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_zoom_in"));
        controls.add(new NextLineProperty());
        controls.add(new SeparatorProperty("node_editing_commands"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_cut"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_copy"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_copy_single"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_paste"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_remove"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_add_arrow_link_action"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_add_local_link_action"));
        controls.add(new NextLineProperty());
        controls.add(new SeparatorProperty("node_navigation_commands"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_moveToRoot"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_move_up"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_move_down"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_move_left"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_move_right"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_follow_link"));
        controls.add(new NextLineProperty());
        controls.add(new SeparatorProperty("new_node_commands"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_add"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_add_child"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_add_child_mac"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_add_sibling_before"));
        controls.add(new NextLineProperty());
        controls.add(new SeparatorProperty("node_editing_commands"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_edit"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_edit_long_node"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_join_nodes"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_toggle_folded"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_toggle_children_folded"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_set_link_by_filechooser"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_set_link_by_textfield"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_set_image_by_filechooser"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_node_up"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_node_down"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_node_increase_font_size"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_node_decrease_font_size"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_export_branch"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_node_color"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_node_color_blend"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_edge_color"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_find"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_find_next"));
        controls.add(new NextLineProperty());
        controls.add(new SeparatorProperty("patterns"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_apply_pattern_1"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_apply_pattern_2"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_apply_pattern_3"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_apply_pattern_4"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_apply_pattern_5"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_apply_pattern_6"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_apply_pattern_7"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_apply_pattern_8"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_apply_pattern_9"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_apply_pattern_10"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_apply_pattern_11"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_apply_pattern_12"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_apply_pattern_13"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_apply_pattern_14"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_apply_pattern_15"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_apply_pattern_16"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_apply_pattern_17"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_apply_pattern_18"));
        controls.add(new NewTabProperty("Behaviour"));
        controls.add(new SeparatorProperty("behaviour"));
        controls.add(new ComboProperty("placenewbranches.tooltip", "placenewbranches", new String[]{"first", "last"}));
        controls.add(new BooleanProperty("draganddrop.tooltip", "draganddrop"));
        controls.add(new BooleanProperty("disable_cursor_move_paper.tooltip", "disable_cursor_move_paper"));
        controls.add(new BooleanProperty("enable_leaves_folding.tooltip", "enable_leaves_folding"));
        controls.add(new StringProperty("foldingsymbolwidth.tooltip", "foldingsymbolwidth"));
        controls.add(new NextLineProperty());
        controls.add(new SeparatorProperty("key_typing"));
        controls.add(new BooleanProperty("disable_key_type.tooltip", "disable_key_type"));
        controls.add(new BooleanProperty("key_type_adds_new.tooltip", "key_type_adds_new"));
        controls.add(new NextLineProperty());
        controls.add(new SeparatorProperty("selection_method"));
        controls.add(new ComboProperty("selection_method.tooltip", "selection_method", new String[]{"selection_method_direct", "selection_method_delayed", "selection_method_by_click"}));
        controls.add(new StringProperty("time_for_delayed_selection.tooltip", "time_for_delayed_selection"));
        controls.add(new NextLineProperty());
        controls.add(new SeparatorProperty("undo"));
        controls.add(new NumberProperty("undo_levels.tooltip", "undo_levels", 2, 1000, 1));
        controls.add(new NewTabProperty("HTML"));
        controls.add(new SeparatorProperty("browser"));
        controls.add(new StringProperty("default_browser_command_windows_nt.tooltip", "default_browser_command_windows_nt"));
        controls.add(new StringProperty("default_browser_command_windows_9x.tooltip", "default_browser_command_windows_9x"));
        controls.add(new StringProperty("default_browser_command_other_os.tooltip", "default_browser_command_other_os"));
        controls.add(new StringProperty("default_browser_command_mac.tooltip", "default_browser_command_mac"));
        controls.add(new ComboProperty(null, "html_export_folding", new String[]{"html_export_no_folding", "html_export_fold_currently_folded", "html_export_fold_all", "html_export_based_on_headings"}));
        controls.add(new NextLineProperty());
        controls.add(new SeparatorProperty("html_export"));
        controls.add(new BooleanProperty("export_icons_in_html.tooltip", "export_icons_in_html"));
        return controls;
    }

    public void closeWindow() {
        try {
            OptionPanelWindowConfigurationStorage storage = fmMain.getController().getActionXmlFactory().createOptionPanelWindowConfigurationStorage();
            storage.setPanel(this.selectedPanel);
            fmMain.getController().storeDialogPositions(this.frame, storage, PREFERENCE_STORAGE_PROPERTY);
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
        this.frame.dispose();
    }

    static {
        changeListeners = new Vector();
        lastKey = "";
    }

    private static class ComboProperty
    extends JComboBox
    implements PropertyControl,
    PropertyBean {
        String description;
        String label;
        private Vector possibleValues;

        public ComboProperty(String description, String label, String[] possibles) {
            this.description = description;
            this.label = label;
            this.fillPossibleValues(possibles);
            Vector<String> possibleTranslations = new Vector<String>();
            Iterator i = this.possibleValues.iterator();
            while (i.hasNext()) {
                String key = (String)i.next();
                possibleTranslations.add(OptionPanel.getText(key));
            }
            this.setModel(new DefaultComboBoxModel(possibleTranslations));
        }

        public ComboProperty(String description, String label, String[] possibles, Vector possibleTranslations) {
            this.description = description;
            this.label = label;
            this.fillPossibleValues(possibles);
            this.setModel(new DefaultComboBoxModel(possibleTranslations));
        }

        private void fillPossibleValues(String[] possibles) {
            this.possibleValues = new Vector();
            this.possibleValues.addAll(Arrays.asList(possibles));
        }

        public String getDescription() {
            return this.description;
        }

        public String getLabel() {
            return this.label;
        }

        public void setValue(String value) {
            if (!this.possibleValues.contains(value)) {
                throw new IllegalArgumentException("Unknown value:" + value);
            }
            super.setSelectedIndex(this.possibleValues.indexOf(value));
        }

        public String getValue() {
            return (String)this.possibleValues.get(super.getSelectedIndex());
        }

        public void layout(DefaultFormBuilder builder) {
            JLabel label = builder.append(OptionPanel.getText(this.getLabel()), (Component)this);
            label.setToolTipText(OptionPanel.getText(this.getDescription()));
        }
    }

    private static class BooleanProperty
    extends JCheckBox
    implements PropertyControl,
    PropertyBean {
        String description;
        String label;

        public BooleanProperty(String description, String label) {
            this.description = description;
            this.label = label;
        }

        public String getDescription() {
            return this.description;
        }

        public String getLabel() {
            return this.label;
        }

        public void setValue(String value) {
            if (value == null || !value.toLowerCase().equals("true") && !value.toLowerCase().equals("false")) {
                throw new IllegalArgumentException("Cannot set a boolean to " + value);
            }
            this.setSelected(value.toLowerCase().equals("true"));
        }

        public String getValue() {
            return this.isSelected() ? "true" : "false";
        }

        public void layout(DefaultFormBuilder builder) {
            JLabel label = builder.append(OptionPanel.getText(this.getLabel()), (Component)this);
            label.setToolTipText(OptionPanel.getText(this.getDescription()));
        }
    }

    private static class KeyProperty
    extends JButton
    implements PropertyControl,
    PropertyBean {
        String description;
        String label;

        public KeyProperty(final JDialog frame, String description, String label) {
            this.description = description;
            this.label = label;
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent arg0) {
                    Vector allKeybindings = new Vector();
                    GrabKeyDialog dialog = new GrabKeyDialog(fmMain, frame, new GrabKeyDialog.KeyBinding(KeyProperty.this.getLabel(), KeyProperty.this.getLabel(), KeyProperty.this.getValue(), false), allKeybindings, null);
                    if (dialog.isOK()) {
                        KeyProperty.this.setValue(dialog.getShortcut());
                    }
                }
            });
        }

        public String getDescription() {
            return this.description;
        }

        public String getLabel() {
            return this.label;
        }

        public void setValue(String value) {
            this.setText(value);
            this.setToolTipText(this.getText());
        }

        public String getValue() {
            return this.getText();
        }

        public void layout(DefaultFormBuilder builder) {
            JLabel label = builder.append(OptionPanel.getText(this.getLabel()), (Component)this);
            label.setToolTipText(OptionPanel.getText(this.getDescription()));
        }
    }

    private static class ColorProperty
    extends JButton
    implements PropertyControl,
    PropertyBean,
    ActionListener {
        String description;
        String label;
        Color color;
        final JPopupMenu menu = new JPopupMenu();
        private final String defaultColor;

        public ColorProperty(String description, String label, String defaultColor) {
            this.description = description;
            this.label = label;
            this.defaultColor = defaultColor;
            this.addActionListener(this);
            this.color = Color.BLACK;
        }

        public String getDescription() {
            return this.description;
        }

        public String getLabel() {
            return this.label;
        }

        public void setValue(String value) {
            this.setColorValue(Tools.xmlToColor(value));
        }

        public String getValue() {
            return Tools.colorToXml(this.getColorValue());
        }

        public void layout(DefaultFormBuilder builder) {
            JLabel label = builder.append(OptionPanel.getText(this.getLabel()), (Component)this);
            label.setToolTipText(OptionPanel.getText(this.getDescription()));
            JMenuItem item = new JMenuItem(fmMain.getResourceString("OptionPanel.ColorProperty.ResetColor"));
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ColorProperty.this.setValue(ColorProperty.this.defaultColor);
                }
            });
            this.menu.add(item);
            this.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent evt) {
                    if (evt.isPopupTrigger()) {
                        ColorProperty.this.menu.show(evt.getComponent(), evt.getX(), evt.getY());
                    }
                }

                public void mouseReleased(MouseEvent evt) {
                    if (evt.isPopupTrigger()) {
                        ColorProperty.this.menu.show(evt.getComponent(), evt.getX(), evt.getY());
                    }
                }
            });
        }

        public void actionPerformed(ActionEvent arg0) {
            Color result = Controller.showCommonJColorChooserDialog(this.getRootPane(), this.getLabel(), this.getColorValue());
            if (result != null) {
                this.setColorValue(result);
            }
        }

        private void setColorValue(Color result) {
            this.color = result;
            this.setBackground(result);
            this.setText(Tools.colorToXml(result));
        }

        private Color getColorValue() {
            return this.color;
        }
    }

    private static class NumberProperty
    implements PropertyControl,
    PropertyBean {
        String description;
        JSlider slider = new JSlider(0, 5, 1000, 100);
        String label;
        private JSpinner spinner;

        public NumberProperty(String description, String label, int min, int max, int step) {
            this.spinner = new JSpinner(new SpinnerNumberModel(min, min, max, step));
            this.description = description;
            this.label = label;
        }

        public String getDescription() {
            return this.description;
        }

        public String getLabel() {
            return this.label;
        }

        public void setValue(String value) {
            int intValue = 100;
            try {
                intValue = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
            this.spinner.setValue(new Integer(intValue));
        }

        public String getValue() {
            return this.spinner.getValue().toString();
        }

        public void layout(DefaultFormBuilder builder) {
            JLabel label = builder.append(OptionPanel.getText(this.getLabel()), (Component)this.spinner);
            label.setToolTipText(OptionPanel.getText(this.getDescription()));
        }
    }

    private static class StringProperty
    extends JTextField
    implements PropertyControl,
    PropertyBean {
        String description;
        String label;

        public StringProperty(String description, String label) {
            this.description = description;
            this.label = label;
        }

        public String getDescription() {
            return this.description;
        }

        public String getLabel() {
            return this.label;
        }

        public void setValue(String value) {
            this.setText(value);
        }

        public String getValue() {
            return this.getText();
        }

        public void layout(DefaultFormBuilder builder) {
            JLabel label = builder.append(OptionPanel.getText(this.getLabel()), (Component)this);
            label.setToolTipText(OptionPanel.getText(this.getDescription()));
        }
    }

    private static class NextLineProperty
    implements PropertyControl {
        public String getDescription() {
            return null;
        }

        public String getLabel() {
            return null;
        }

        public void layout(DefaultFormBuilder builder) {
            builder.nextLine();
        }
    }

    private static class NewTabProperty
    implements PropertyControl {
        private String label;
        private String layoutFormat;

        public NewTabProperty(String label) {
            this(label, OptionPanel.DEFAULT_LAYOUT_FORMAT);
        }

        public NewTabProperty(String label, String layoutFormat) {
            this.label = label;
            this.layoutFormat = layoutFormat;
        }

        public String getDescription() {
            return this.layoutFormat;
        }

        public String getLabel() {
            return this.label;
        }

        public void layout(DefaultFormBuilder builder) {
        }
    }

    private static class SeparatorProperty
    implements PropertyControl {
        private String label;

        public SeparatorProperty(String label) {
            this.label = label;
        }

        public String getDescription() {
            return null;
        }

        public String getLabel() {
            return this.label;
        }

        public void layout(DefaultFormBuilder builder) {
            builder.appendSeparator(OptionPanel.getText("separator." + this.getLabel()));
        }
    }

    private static interface PropertyBean {
        public String getLabel();

        public void setValue(String var1);

        public String getValue();
    }

    private static interface PropertyControl {
        public String getDescription();

        public String getLabel();

        public void layout(DefaultFormBuilder var1);
    }

    private final class ChangeTabAction
    implements ActionListener {
        private CardLayout cardLayout;
        private JPanel centralPanel;
        private String tabName;

        private ChangeTabAction(CardLayout cardLayout, JPanel centralPanel, String tabName) {
            this.cardLayout = cardLayout;
            this.centralPanel = centralPanel;
            this.tabName = tabName;
        }

        public void actionPerformed(ActionEvent arg0) {
            this.cardLayout.show(this.centralPanel, this.tabName);
            Collection c = OptionPanel.this.getAllButtons();
            Iterator i = c.iterator();
            while (i.hasNext()) {
                JButton button = (JButton)i.next();
                button.setForeground(null);
            }
            OptionPanel.this.getTabButton(this.tabName).setForeground(MARKED_BUTTON_COLOR);
            OptionPanel.this.selectedPanel = this.tabName;
        }
    }

    public static interface OptionPanelFeedback {
        public void writeProperties(Properties var1);
    }
}

