/*
 * Decompiled with CFR 0.152.
 */
package freemind.view.mindmapview;

import freemind.modes.MindMapNode;
import freemind.view.mindmapview.MapView;
import freemind.view.mindmapview.MoveableNodeView;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Stroke;

public class BubbleNodeView
extends MoveableNodeView {
    private static final Stroke BOLD_STROKE = new BasicStroke(2.0f, 0, 0, 1.0f, new float[]{2.0f, 2.0f}, 0.0f);
    private static final Stroke DEF_STROKE = new BasicStroke();

    public BubbleNodeView(MindMapNode model, MapView map) {
        super(model, map);
    }

    protected int getExtendedWidth(int width) {
        int dW = this.getZoomedFoldingSymbolHalfWidth() * 2;
        if (this.getModel().isFolded()) {
            width += dW;
        }
        return width + dW;
    }

    public int getExtendedX() {
        int x = this.getX();
        if (this.getModel().isFolded() && this.isLeft()) {
            x -= this.getZoomedFoldingSymbolHalfWidth() * 2;
        }
        return x;
    }

    public void paintSelected(Graphics2D graphics, Dimension size) {
        super.paintSelected(graphics, size);
        if (this.isSelected()) {
            graphics.setColor(selectedColor);
            graphics.fillRoundRect(0, 0, size.width - 1, size.height - 1, 10, 10);
        }
    }

    public void paintFoldingMark(Graphics2D g) {
        if (this.getModel().isFolded()) {
            int height = this.getSize().height / 2;
            int MAX_HEIGHT = 50;
            if (height > 50) {
                height = 50;
            }
            Point ovalStartPoint = this.getOutPoint();
            if (this.isLeft()) {
                ovalStartPoint.translate(-this.getZoomedFoldingSymbolHalfWidth() * 2, -this.getZoomedFoldingSymbolHalfWidth());
            } else {
                ovalStartPoint.translate(0, -this.getZoomedFoldingSymbolHalfWidth());
            }
            g.drawOval(ovalStartPoint.x, ovalStartPoint.y, this.getZoomedFoldingSymbolHalfWidth() * 2, this.getZoomedFoldingSymbolHalfWidth() * 2);
        }
    }

    public void paint(Graphics graphics) {
        Graphics2D g = (Graphics2D)graphics;
        Dimension size = this.getSize();
        if (this.getModel() == null) {
            return;
        }
        this.paintSelected(g, size);
        this.paintDragOver(g, size);
        this.setRendering(g);
        g.setColor(this.getEdge().getColor());
        if (this.map.getController().getAntialiasEdges()) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        g.drawRoundRect(0, 0, size.width - 1, size.height - 1, 10, 10);
        if (this.map.getController().getAntialiasEdges()) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        g.setStroke(DEF_STROKE);
        super.paint(g);
    }

    Point getOutPoint() {
        Dimension size = this.getSize();
        if (this.isLeft()) {
            return new Point(this.getLocation().x, this.getLocation().y + size.height / 2);
        }
        return new Point(this.getLocation().x + size.width, this.getLocation().y + size.height / 2);
    }

    Point getInPoint() {
        Dimension size = this.getSize();
        if (this.isLeft()) {
            return new Point(this.getLocation().x + size.width, this.getLocation().y + size.height / 2);
        }
        return new Point(this.getLocation().x, this.getLocation().y + size.height / 2);
    }

    int getAlignment() {
        return 0;
    }

    protected void paintBackground(Graphics2D graphics, Dimension size, Color color) {
        graphics.setColor(color);
        graphics.fillRoundRect(0, 0, size.width - 1, size.height - 1, 10, 10);
    }

    String getStyle() {
        return "bubble";
    }

    public Dimension getPreferredSize() {
        Dimension prefSize = super.getPreferredSize();
        prefSize.width += 5;
        return prefSize;
    }
}

