/*
 * Decompiled with CFR 0.152.
 */
package freemind.view.mindmapview;

import freemind.controller.Controller;
import freemind.main.FreeMindMain;
import freemind.main.Tools;
import freemind.modes.MindIcon;
import freemind.modes.MindMapCloud;
import freemind.modes.MindMapNode;
import freemind.modes.NodeAdapter;
import freemind.preferences.FreemindPropertyListener;
import freemind.view.mindmapview.BezierEdgeView;
import freemind.view.mindmapview.BubbleNodeView;
import freemind.view.mindmapview.CloudView;
import freemind.view.mindmapview.EdgeView;
import freemind.view.mindmapview.ForkNodeView;
import freemind.view.mindmapview.LinearEdgeView;
import freemind.view.mindmapview.MapView;
import freemind.view.mindmapview.MultipleImage;
import freemind.view.mindmapview.NodeMotionListenerView;
import freemind.view.mindmapview.RootNodeView;
import freemind.view.mindmapview.SharpBezierEdgeView;
import freemind.view.mindmapview.SharpLinearEdgeView;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetListener;
import java.net.MalformedURLException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.ImageIcon;
import javax.swing.JLabel;

public abstract class NodeView
extends JLabel {
    protected MindMapNode model;
    protected MapView map;
    protected EdgeView edge;
    protected static final Color selectedColor = new Color(210, 210, 210);
    protected static final Color dragColor = Color.lightGray;
    protected int treeWidth = 0;
    protected int treeHeight = 0;
    protected int upperChildShift = 0;
    private boolean left = true;
    int relYPos = 0;
    private boolean isLong = false;
    public static final int DRAGGED_OVER_NO = 0;
    public static final int DRAGGED_OVER_SON = 1;
    public static final int DRAGGED_OVER_SIBLING = 2;
    public static final int DRAGGED_OVER_SON_LEFT = 3;
    protected int isDraggedOver = 0;
    static final int ALIGN_BOTTOM = -1;
    static final int ALIGN_CENTER = 0;
    static final int ALIGN_TOP = 1;
    private static Color standardSelectColor;
    private static Color standardNodeColor;
    private static boolean NEED_PREF_SIZE_BUG_FIX;
    private static final int MIN_HOR_NODE_SIZE = 10;

    public void setDraggedOver(int draggedOver) {
        this.isDraggedOver = draggedOver;
    }

    public void setDraggedOver(Point p) {
        this.setDraggedOver(this.dropAsSibling(p.getX()) ? 2 : 1);
    }

    public int getDraggedOver() {
        return this.isDraggedOver;
    }

    protected NodeView(MindMapNode model, MapView map) {
        this.setHorizontalAlignment(0);
        this.model = model;
        this.setMap(map);
        if (standardNodeColor == null) {
            standardNodeColor = Tools.xmlToColor(map.getController().getProperty("standardnodecolor"));
            Controller.addPropertyChangeListener(new FreemindPropertyListener(){

                public void propertyChanged(String propertyName, String newValue, String oldValue) {
                    if (propertyName.equals("standardnodecolor")) {
                        standardNodeColor = Tools.xmlToColor(newValue);
                    }
                    if (propertyName.equals("standardselectednodecolor")) {
                        standardSelectColor = Tools.xmlToColor(newValue);
                    }
                }
            });
        }
        if (standardSelectColor == null) {
            String stdcolor = map.getController().getFrame().getProperty("standardselectednodecolor");
            standardSelectColor = stdcolor.length() == 7 ? Tools.xmlToColor(stdcolor) : new Color(210, 210, 210);
        }
        if (!this.isRoot()) {
            if (this.getModel().getEdge().getStyle().equals("linear")) {
                this.edge = new LinearEdgeView(this.getParentView(), this);
            } else if (this.getModel().getEdge().getStyle().equals("bezier")) {
                this.edge = new BezierEdgeView(this.getParentView(), this);
            } else if (this.getModel().getEdge().getStyle().equals("sharp_linear")) {
                this.edge = new SharpLinearEdgeView(this.getParentView(), this);
            } else if (this.getModel().getEdge().getStyle().equals("sharp_bezier")) {
                this.edge = new SharpBezierEdgeView(this.getParentView(), this);
            } else {
                System.err.println("Unknown Edge Type.");
            }
        }
        this.addMouseListener(map.getNodeMouseMotionListener());
        this.addMouseMotionListener(map.getNodeMouseMotionListener());
        this.addKeyListener(map.getNodeKeyListener());
        this.addDragListener(map.getNodeDragListener());
        this.addDropListener(map.getNodeDropListener());
    }

    protected void addToMap() {
        this.map.add(this);
    }

    protected void removeFromMap() {
        this.map.remove(this);
    }

    void addDragListener(DragGestureListener dgl) {
        DragSource dragSource = DragSource.getDefaultDragSource();
        dragSource.createDefaultDragGestureRecognizer(this, 0x40000003, dgl);
    }

    void addDropListener(DropTargetListener dtl) {
        DropTarget dropTarget = new DropTarget(this, dtl);
        dropTarget.setActive(true);
    }

    protected static NodeView newNodeView(MindMapNode model, MapView map) {
        NodeView newView;
        if (model.isRoot()) {
            newView = new RootNodeView(model, map);
        } else if (model.getStyle().equals("fork")) {
            newView = new ForkNodeView(model, map);
        } else if (model.getStyle().equals("bubble")) {
            newView = new BubbleNodeView(model, map);
        } else {
            System.err.println("Tried to create a NodeView of unknown Style.");
            newView = new ForkNodeView(model, map);
        }
        model.setViewer(newView);
        newView.addToMap();
        newView.update();
        return newView;
    }

    public boolean dropAsSibling(double xCoord) {
        return this.isInVerticalRegion(xCoord, 0.3333333333333333);
    }

    public boolean isInVerticalRegion(double xCoord, double p) {
        return this.isLeft() ? xCoord > (double)this.getSize().width * (1.0 - p) : xCoord < (double)this.getSize().width * p;
    }

    public boolean dropPosition(double xCoord) {
        return this.isLeft();
    }

    public boolean isInFollowLinkRegion(double xCoord) {
        return this.getModel().getLink() != null && (this.getModel().isRoot() || !this.getModel().hasChildren() || this.isInVerticalRegion(xCoord, 0.5));
    }

    public boolean updateCursor(double xCoord) {
        int requiredCursor;
        boolean followLink = this.isInFollowLinkRegion(xCoord);
        int n = requiredCursor = followLink ? 12 : 0;
        if (this.getCursor().getType() != requiredCursor) {
            this.setCursor(new Cursor(requiredCursor));
        }
        return followLink;
    }

    public boolean isRoot() {
        return this.model.isRoot();
    }

    public boolean getIsLong() {
        return this.isLong;
    }

    public boolean isSiblingOf(NodeView myNodeView) {
        return this.getParentView() == myNodeView.getParentView();
    }

    public boolean isChildOf(NodeView myNodeView) {
        return this.getParentView() == myNodeView;
    }

    public boolean isParentOf(NodeView myNodeView) {
        return this == myNodeView.getParentView();
    }

    public MindMapNode getModel() {
        return this.model;
    }

    public void getCoordinates(LinkedList inList) {
        this.getCoordinates(inList, 0, false);
    }

    private void getCoordinates(LinkedList inList, int additionalDistanceForConvexHull, boolean byChildren) {
        MindMapCloud cloud = this.getModel().getCloud();
        if (byChildren && cloud != null) {
            additionalDistanceForConvexHull += CloudView.getAdditionalHeigth(cloud, this) / 2;
        }
        inList.addLast(new Point(-additionalDistanceForConvexHull + this.getExtendedX(), -additionalDistanceForConvexHull + this.getExtendedY()));
        inList.addLast(new Point(-additionalDistanceForConvexHull + this.getExtendedX(), additionalDistanceForConvexHull + this.getExtendedY() + this.getExtendedHeight()));
        inList.addLast(new Point(additionalDistanceForConvexHull + this.getExtendedX() + this.getExtendedWidth(), additionalDistanceForConvexHull + this.getExtendedY() + this.getExtendedHeight()));
        inList.addLast(new Point(additionalDistanceForConvexHull + this.getExtendedX() + this.getExtendedWidth(), -additionalDistanceForConvexHull + this.getExtendedY()));
        LinkedList childrenViews = this.getChildrenViews();
        ListIterator children_it = childrenViews.listIterator();
        while (children_it.hasNext()) {
            NodeView child = (NodeView)children_it.next();
            child.getCoordinates(inList, additionalDistanceForConvexHull, true);
        }
    }

    public Dimension getPreferredSize() {
        boolean isEmpty;
        boolean bl = isEmpty = this.getText().length() == 0;
        if (isEmpty) {
            this.setText("!");
        }
        Dimension prefSize = super.getPreferredSize();
        if (this.map.isCurrentlyPrinting() && NEED_PREF_SIZE_BUG_FIX) {
            prefSize.width += (int)(10.0f * this.map.getZoom());
        }
        prefSize.width = Math.max(this.map.getZoomed(10), prefSize.width);
        if (isEmpty) {
            this.setText("");
        }
        prefSize.width += 4;
        prefSize.height += 4;
        return prefSize;
    }

    public int getExtendedWidth() {
        return this.getExtendedWidth(this.getWidth());
    }

    public int getExtendedHeight() {
        return this.getExtendedHeight(this.getHeight());
    }

    protected int getExtendedWidth(int w) {
        return w;
    }

    protected int getExtendedHeight(int h) {
        return h;
    }

    public int getExtendedX() {
        return this.getX();
    }

    public int getExtendedY() {
        return this.getY();
    }

    public void setBounds(int x, int y) {
        this.setLocation(x, y);
        this.setSize(this.getPreferredSize());
    }

    public void requestFocus() {
        this.map.getController().getMode().getModeController().anotherNodeSelected(this.getModel());
        super.requestFocus();
    }

    public void paintFoldingMark(Graphics2D g) {
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
    }

    public void paintSelected(Graphics2D graphics, Dimension size) {
        if (this.isSelected()) {
            this.paintBackground(graphics, size, this.getSelectedColor());
        } else if (this.getModel().getBackgroundColor() != null) {
            this.paintBackground(graphics, size, this.getModel().getBackgroundColor());
        }
    }

    protected void paintBackground(Graphics2D graphics, Dimension size, Color color) {
        graphics.setColor(color);
        graphics.fillRect(0, 0, size.width, size.height);
    }

    public void paintDragOver(Graphics2D graphics, Dimension size) {
        if (this.isDraggedOver == 1) {
            if (this.isLeft()) {
                graphics.setPaint(new GradientPaint(size.width * 3 / 4, 0.0f, this.map.getBackground(), size.width / 4, 0.0f, dragColor));
                graphics.fillRect(0, 0, size.width * 3 / 4, size.height - 1);
            } else {
                graphics.setPaint(new GradientPaint(size.width / 4, 0.0f, this.map.getBackground(), size.width * 3 / 4, 0.0f, dragColor));
                graphics.fillRect(size.width / 4, 0, size.width - 1, size.height - 1);
            }
        }
        if (this.isDraggedOver == 2) {
            graphics.setPaint(new GradientPaint(0.0f, size.height * 3 / 5, this.map.getBackground(), 0.0f, size.height / 5, dragColor));
            graphics.fillRect(0, 0, size.width - 1, size.height - 1);
        }
    }

    public int getAdditionalCloudHeigth() {
        MindMapCloud cloud = this.getModel().getCloud();
        if (cloud != null) {
            return CloudView.getAdditionalHeigth(cloud, this);
        }
        return 0;
    }

    protected boolean isSelected() {
        return this.getMap().isSelected(this);
    }

    public boolean isLeft() {
        if (this.getModel().isLeft() == null) {
            return true;
        }
        return this.getModel().isLeft().getValue();
    }

    protected void setLeft(boolean left) {
        this.getModel().setLeft(left);
    }

    protected void setModel(MindMapNode model) {
        this.model = model;
    }

    MapView getMap() {
        return this.map;
    }

    protected void setMap(MapView map) {
        this.map = map;
    }

    EdgeView getEdge() {
        return this.edge;
    }

    void setEdge(EdgeView edge) {
        this.edge = edge;
    }

    protected NodeView getParentView() {
        return this.getModel().getParentNode().getViewer();
    }

    public LinkedList getChildrenViews() {
        LinkedList<NodeView> childrenViews = new LinkedList<NodeView>();
        ListIterator it = this.getModel().childrenUnfolded();
        if (it != null) {
            while (it.hasNext()) {
                NodeView view = ((MindMapNode)it.next()).getViewer();
                if (view == null) continue;
                childrenViews.add(view);
            }
        }
        return childrenViews;
    }

    protected LinkedList getSiblingViews() {
        return this.getParentView().getChildrenViews();
    }

    Point getOutPoint() {
        Dimension size = this.getSize();
        if (this.isRoot()) {
            return new Point(this.getLocation().x + size.width, this.getLocation().y + size.height / 2);
        }
        if (this.isLeft()) {
            return new Point(this.getLocation().x, this.getLocation().y + size.height - 2);
        }
        return new Point(this.getLocation().x + size.width, this.getLocation().y + size.height - 2);
    }

    Point getOutPoint(Point destinationPoint, boolean isLeft) {
        return this.getOutPoint();
    }

    Point getInPoint() {
        Dimension size = this.getSize();
        if (this.isRoot()) {
            return new Point(this.getLocation().x, this.getLocation().y + size.height / 2);
        }
        if (this.isLeft()) {
            return new Point(this.getLocation().x + size.width, this.getLocation().y + size.height - 2);
        }
        return new Point(this.getLocation().x, this.getLocation().y + size.height - 2);
    }

    public Point getLinkPoint(Point declination) {
        int y;
        int x;
        Dimension size = this.getSize();
        if (declination != null) {
            x = this.getMap().getZoomed(declination.x);
            y = this.getMap().getZoomed(declination.y);
        } else {
            x = 1;
            y = 0;
        }
        if (this.isRoot() || this.isLeft()) {
            x = -x;
        }
        if (y != 0) {
            int absLinkY;
            int absLinkX;
            double ctgLine;
            double ctgRect = Math.abs((double)size.width / (double)size.height);
            if (ctgRect > (ctgLine = Math.abs((double)x / (double)y))) {
                absLinkX = Math.abs(x * size.height / (2 * y));
                absLinkY = size.height / 2;
            } else {
                absLinkX = size.width / 2;
                absLinkY = Math.abs(y * size.width / (2 * x));
            }
            return new Point(this.getLocation().x + size.width / 2 + (x > 0 ? absLinkX : -absLinkX), this.getLocation().y + size.height / 2 + (y > 0 ? absLinkY : -absLinkY));
        }
        return new Point(this.getLocation().x + (x > 0 ? size.width : 0), this.getLocation().y + size.height / 2);
    }

    int getAlignment() {
        if (this.isRoot()) {
            return 0;
        }
        return -1;
    }

    protected NodeView getNextPage() {
        if (this.isRoot()) {
            return this;
        }
        NodeView sibling = this.getNextSibling();
        if (sibling == this) {
            return this;
        }
        for (NodeView nextSibling = sibling.getNextSibling(); nextSibling != sibling && sibling.getParentView() == nextSibling.getParentView(); nextSibling = nextSibling.getNextSibling()) {
            sibling = nextSibling;
        }
        return sibling;
    }

    protected NodeView getPreviousPage() {
        if (this.isRoot()) {
            return this;
        }
        NodeView sibling = this.getPreviousSibling();
        if (sibling == this) {
            return this;
        }
        for (NodeView previousSibling = sibling.getPreviousSibling(); previousSibling != sibling && sibling.getParentView() == previousSibling.getParentView(); previousSibling = previousSibling.getPreviousSibling()) {
            sibling = previousSibling;
        }
        return sibling;
    }

    protected NodeView getNextSibling() {
        NodeView sibling;
        NodeView nextSibling = this;
        for (sibling = this; !sibling.isRoot() && sibling == (nextSibling = sibling.getNextSiblingSingle()); sibling = sibling.getParentView()) {
        }
        if (sibling.isRoot()) {
            return this;
        }
        sibling = nextSibling;
        while (sibling.getModel().getNodeLevel() < this.getMap().getSiblingMaxLevel() && sibling.getChildrenViews().size() > 0) {
            sibling = (NodeView)sibling.getChildrenViews().getFirst();
        }
        return sibling;
    }

    protected NodeView getPreviousSibling() {
        NodeView sibling;
        NodeView previousSibling = this;
        for (sibling = this; !sibling.isRoot() && sibling == (previousSibling = sibling.getPreviousSiblingSingle()); sibling = sibling.getParentView()) {
        }
        if (sibling.isRoot()) {
            return this;
        }
        sibling = previousSibling;
        while (sibling.getModel().getNodeLevel() < this.getMap().getSiblingMaxLevel() && sibling.getChildrenViews().size() > 0) {
            sibling = (NodeView)sibling.getChildrenViews().getLast();
        }
        return sibling;
    }

    protected NodeView getNextSiblingSingle() {
        LinkedList v = null;
        v = this.getParentView().isRoot() ? (this.isLeft() ? ((RootNodeView)this.getParentView()).getLeft() : ((RootNodeView)this.getParentView()).getRight()) : this.getParentView().getChildrenViews();
        NodeView sibling = v.size() - 1 == v.indexOf(this) ? this : (NodeView)v.get(v.indexOf(this) + 1);
        return sibling;
    }

    protected NodeView getPreviousSiblingSingle() {
        LinkedList v = null;
        v = this.getParentView().isRoot() ? (this.isLeft() ? ((RootNodeView)this.getParentView()).getLeft() : ((RootNodeView)this.getParentView()).getRight()) : this.getParentView().getChildrenViews();
        NodeView sibling = v.indexOf(this) <= 0 ? this : (NodeView)v.get(v.indexOf(this) - 1);
        return sibling;
    }

    void insert() {
        ListIterator it = this.getModel().childrenFolded();
        while (it.hasNext()) {
            this.insert((MindMapNode)it.next());
        }
    }

    void insert(MindMapNode newNode) {
        NodeView newView = NodeView.newNodeView(newNode, this.getMap());
        newView.setLeft(this.isLeft());
        ListIterator it = newNode.childrenFolded();
        while (it.hasNext()) {
            MindMapNode child = (MindMapNode)it.next();
            newView.insert(child);
        }
    }

    void remove() {
        this.removeFromMap();
        if (this.getEdge() != null) {
            this.getEdge().remove();
        }
        this.getModel().setViewer(null);
        ListIterator e = this.getChildrenViews().listIterator();
        while (e.hasNext()) {
            ((NodeView)e.next()).remove();
        }
    }

    void update() {
        Object myIcon;
        Color color = this.getModel().getColor();
        if (color == null) {
            color = standardNodeColor;
        }
        this.setForeground(color);
        this.setHorizontalTextPosition(this.getModel().isOneLeftSideOfRoot() ? 10 : 11);
        MultipleImage iconImages = new MultipleImage(this.map.getZoom());
        boolean iconPresent = false;
        FreeMindMain frame = this.map.getController().getFrame();
        Map stateIcons = this.getModel().getStateIcons();
        Iterator i = stateIcons.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            iconPresent = true;
            myIcon = (ImageIcon)stateIcons.get(key);
            iconImages.addImage((ImageIcon)myIcon);
        }
        List icons = this.getModel().getIcons();
        Iterator i2 = icons.iterator();
        while (i2.hasNext()) {
            myIcon = (MindIcon)i2.next();
            iconPresent = true;
            iconImages.addImage(((MindIcon)myIcon).getIcon(frame));
        }
        String link = ((NodeAdapter)this.getModel()).getLink();
        if (link != null) {
            iconPresent = true;
            ImageIcon icon = new ImageIcon(frame.getResource(link.startsWith("mailto:") ? "images/Mail.png" : (Tools.executableByExtension(link) ? "images/Executable.png" : "images/Link.png")));
            iconImages.addImage(icon);
        }
        this.setIcon(iconPresent ? iconImages : null);
        Font font = this.getModel().getFont();
        Font font2 = font = font == null ? this.map.getController().getDefaultFont() : font;
        if (font != null) {
            if (this.map.getZoom() != 1.0f) {
                font = font.deriveFont((float)font.getSize() * this.map.getZoom());
            }
            this.setFont(font);
        } else {
            System.err.println("NodeView.update(): default font is null.");
        }
        String nodeText = ((Object)this.getModel()).toString();
        String[] lines = nodeText.split("\n");
        boolean widthMustBeRestricted = false;
        lines = nodeText.split("\n");
        for (int line = 0; line < lines.length; ++line) {
            this.setText(lines[line]);
            boolean bl = widthMustBeRestricted = this.getPreferredSize().width > this.map.getZoomed(this.map.getMaxNodeWidth());
            if (widthMustBeRestricted) break;
        }
        boolean bl = this.isLong = widthMustBeRestricted || lines.length > 1;
        if (nodeText.startsWith("<html>")) {
            if (nodeText.indexOf("<img") >= 0 && nodeText.indexOf("<base ") < 0) {
                try {
                    nodeText = "<html><base href=\"" + this.map.getModel().getURL() + "\">" + nodeText.substring(6);
                }
                catch (MalformedURLException e) {
                    // empty catch block
                }
            }
            this.setText(nodeText);
        } else if (nodeText.startsWith("<table>")) {
            lines[0] = lines[0].substring(7);
            int startingLine = lines[0].matches("\\s*") ? 1 : 0;
            String text = "<html><table border=1 style=\"border-color: white\">";
            for (int line = startingLine; line < lines.length; ++line) {
                text = text + "<tr><td style=\"border-color: white;\">" + Tools.toXMLEscapedText(lines[line]).replaceAll("\t", "<td style=\"border-color: white\">");
            }
            this.setText(text);
        } else if (this.isLong) {
            String text = "<tr><td>";
            int maximumLineLength = 0;
            for (int line = 0; line < lines.length; ++line) {
                text = text + Tools.toXMLEscapedTextWithNBSPizedSpaces(lines[line]) + "<p>";
                if (lines[line].length() <= maximumLineLength) continue;
                maximumLineLength = lines[line].length();
            }
            text = text + "</td></tr>";
            this.setText("<html><table" + (!widthMustBeRestricted ? ">" : " width=\"" + this.map.getZoomed(this.map.getMaxNodeWidth()) + "\">") + text + "</table></html>");
        }
        this.updateToolTip();
        this.repaint();
    }

    public void updateToolTip() {
        Map tooltips = this.getModel().getToolTip();
        if (tooltips.size() == 1) {
            this.setToolTipText((String)tooltips.values().iterator().next());
        } else if (tooltips.size() == 0) {
            this.setToolTipText(null);
        } else {
            StringBuffer text = new StringBuffer("<html><table>");
            Set keySet = tooltips.keySet();
            TreeSet sortedKeySet = new TreeSet();
            sortedKeySet.addAll(keySet);
            Iterator i = sortedKeySet.iterator();
            while (i.hasNext()) {
                String key = (String)i.next();
                String value = (String)tooltips.get(key);
                text.append("<tr><td>");
                text.append(value);
                text.append("</td></tr>");
            }
            text.append("</table></html>");
            this.setToolTipText(text.toString());
        }
    }

    void updateAll() {
        this.update();
        ListIterator e = this.getChildrenViews().listIterator();
        while (e.hasNext()) {
            NodeView child = (NodeView)e.next();
            child.updateAll();
        }
    }

    protected void setRendering(Graphics2D g) {
        if (this.map.getController().getAntialiasAll()) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
    }

    abstract String getStyle();

    public int getTreeHeight() {
        return this.treeHeight;
    }

    public void setTreeHeight(int i) {
        this.treeHeight = i;
    }

    public int getTreeWidth() {
        return this.treeWidth;
    }

    public void setTreeWidth(int i) {
        this.treeWidth = i;
    }

    public int getZoomedFoldingSymbolHalfWidth() {
        int preferredFoldingSymbolHalfWidth = this.map.getZoomedFoldingSymbolHalfWidth();
        return Math.min(preferredFoldingSymbolHalfWidth, super.getPreferredSize().height / 2);
    }

    protected Color getSelectedColor() {
        return standardSelectColor;
    }

    protected static Color getAntiColor1(Color c) {
        float[] hsb = Color.RGBtoHSB(c.getRed(), c.getGreen(), c.getBlue(), null);
        hsb[0] = (float)((double)hsb[0] + 0.4);
        if (hsb[0] > 1.0f) {
            hsb[0] = hsb[0] - 1.0f;
        }
        hsb[1] = 1.0f;
        hsb[2] = 0.7f;
        return Color.getHSBColor(hsb[0], hsb[1], hsb[2]);
    }

    protected static Color getAntiColor2(Color c) {
        float[] hsb = Color.RGBtoHSB(c.getRed(), c.getGreen(), c.getBlue(), null);
        hsb[0] = (float)((double)hsb[0] - 0.4);
        if (hsb[0] < 0.0f) {
            hsb[0] = hsb[0] + 1.0f;
        }
        hsb[1] = 1.0f;
        hsb[2] = 0.8f;
        return Color.getHSBColor(hsb[0], hsb[1], hsb[2]);
    }

    public int getShift() {
        return this.map.getZoomed(this.model.calcShiftY());
    }

    public int getVGap() {
        return this.map.getZoomed(this.model.calcVGap());
    }

    public int getHGap() {
        return this.map.getZoomed(this.model.getHGap());
    }

    public int getUpperChildShift() {
        return this.upperChildShift;
    }

    public void setUpperChildShift(int treeShift) {
        this.upperChildShift = treeShift;
    }

    public NodeMotionListenerView getMotionListenerView() {
        return null;
    }

    static {
        NEED_PREF_SIZE_BUG_FIX = Controller.JAVA_VERSION.compareTo("1.5.0") < 0;
    }
}

