/*
 * Decompiled with CFR 0.152.
 */
package freemind.view.mindmapview;

import freemind.modes.MindMapNode;
import freemind.view.mindmapview.EdgeView;
import freemind.view.mindmapview.MapView;
import freemind.view.mindmapview.NodeView;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.util.LinkedList;
import java.util.ListIterator;

public class RootNodeView
extends NodeView {
    protected int leftTreeWidth = 0;
    protected int rightTreeWidth = 0;

    public RootNodeView(MindMapNode model, MapView map) {
        super(model, map);
    }

    public NodeView getParentView() {
        return null;
    }

    Point getOutPoint() {
        Dimension size = this.getSize();
        return new Point(this.getLocation().x + size.width, this.getLocation().y + size.height / 2);
    }

    Point getOutPoint(Point destinationPoint, boolean isLeft) {
        return isLeft ? this.getInPoint() : this.getOutPoint();
    }

    Point getInPoint() {
        Dimension size = this.getSize();
        return new Point(this.getLocation().x, this.getLocation().y + size.height / 2);
    }

    EdgeView getEdge() {
        return null;
    }

    void setEdge(EdgeView edge) {
    }

    LinkedList getLeft() {
        LinkedList all = this.getChildrenViews();
        LinkedList<NodeView> left = new LinkedList<NodeView>();
        ListIterator e = all.listIterator();
        while (e.hasNext()) {
            NodeView node = (NodeView)e.next();
            if (node == null || !node.isLeft()) continue;
            left.add(node);
        }
        return left;
    }

    LinkedList getRight() {
        LinkedList all = this.getChildrenViews();
        LinkedList<NodeView> right = new LinkedList<NodeView>();
        ListIterator e = all.listIterator();
        while (e.hasNext()) {
            NodeView node = (NodeView)e.next();
            if (node == null || node.isLeft()) continue;
            right.add(node);
        }
        return right;
    }

    void insert(MindMapNode newNode) {
        ListIterator it;
        NodeView newView = RootNodeView.newNodeView(newNode, this.getMap());
        newView.update();
        if (newNode.isLeft() == null) {
            newView.setLeft(this.getLeft().size() <= this.getRight().size());
        }
        if ((it = newNode.childrenFolded()) != null) {
            while (it.hasNext()) {
                MindMapNode child = (MindMapNode)it.next();
                newView.insert(child);
            }
        }
    }

    public boolean dropAsSibling(double xCoord) {
        return false;
    }

    public boolean dropPosition(double xCoord) {
        return xCoord < (double)(this.getSize().width * 1 / 2);
    }

    public void setDraggedOver(Point p) {
        this.setDraggedOver(this.dropPosition(p.getX()) ? 3 : 1);
    }

    public NodeView getNextSibling() {
        return this;
    }

    public NodeView getPreviousSibling() {
        return this;
    }

    public void paint(Graphics graphics) {
        Graphics2D g = (Graphics2D)graphics;
        Dimension size = this.getSize();
        if (this.getModel() == null) {
            return;
        }
        this.paintSelected(g, size);
        this.paintDragOver(g, size);
        g.setColor(Color.gray);
        g.setStroke(new BasicStroke(1.0f));
        this.setRendering(g);
        g.drawOval(1, 1, size.width - 2, size.height - 2);
        if (!this.getMap().getController().getAntialiasAll()) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        super.paint(g);
    }

    public void paintDragOver(Graphics2D graphics, Dimension size) {
        if (this.getDraggedOver() == 1) {
            graphics.setPaint(new GradientPaint(size.width / 4, 0.0f, this.map.getBackground(), size.width * 3 / 4, 0.0f, dragColor));
            graphics.fillRect(size.width / 4, 0, size.width - 1, size.height - 1);
        } else if (this.getDraggedOver() == 3) {
            graphics.setPaint(new GradientPaint(size.width * 3 / 4, 0.0f, this.map.getBackground(), size.width / 4, 0.0f, dragColor));
            graphics.fillRect(0, 0, size.width * 3 / 4, size.height - 1);
        }
    }

    protected void setRendering(Graphics2D g) {
        if (this.getMap().getController().getAntialiasEdges() || this.getMap().getController().getAntialiasAll()) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
    }

    protected void paintBackground(Graphics2D graphics, Dimension size, Color color) {
        graphics.setColor(color);
        graphics.fillOval(1, 1, size.width - 1, size.height - 1);
    }

    public int getRightTreeWidth() {
        return this.rightTreeWidth;
    }

    public int getLeftTreeWidth() {
        return this.leftTreeWidth;
    }

    public void setTreeWidth(int w) {
        throw new Error();
    }

    public void setRootTreeWidths(int left, int right) {
        this.leftTreeWidth = left - this.getPreferredSize().width;
        this.rightTreeWidth = right;
        super.setTreeWidth(this.leftTreeWidth + this.rightTreeWidth);
    }

    public void setRootTreeHeights(int left, int right) {
        if (left > right) {
            super.setTreeHeight(left);
        } else {
            super.setTreeHeight(right);
        }
    }

    public void setRootUpperChildShift(int left, int right) {
        super.setUpperChildShift(Math.max(left, right));
    }

    String getStyle() {
        return this.model.getStyle();
    }

    public Dimension getPreferredSize() {
        Dimension prefSize = super.getPreferredSize();
        prefSize.width += Math.max(10, prefSize.width / 10);
        prefSize.height *= 2;
        return prefSize;
    }
}

